/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.cntk.predictionpostprocessor;

import adams.core.Utils;
import adams.data.statistics.StatUtils;
import adams.ml.cntk.predictionpostprocessor.AbstractPredictionPostProcessor;

public class Normalize
extends AbstractPredictionPostProcessor {
    private static final long serialVersionUID = -7840089137915934092L;

    public String globalInfo() {
        return "Normalizes the predictions, making them sum up to 1 with the individual values ranging from 0 to 1.";
    }

    @Override
    public float[] postProcessPrediction(float[] preds) {
        int i;
        Number min = StatUtils.min((Number[])StatUtils.toNumberArray((float[])preds));
        Number max = StatUtils.max((Number[])StatUtils.toNumberArray((float[])preds));
        if (min == null || max == null) {
            this.getLogger().severe("Failed to determine min and/or max: " + Utils.arrayToString((Object)preds));
            return preds;
        }
        if (min.equals(max)) {
            return preds;
        }
        float range = max.floatValue() - min.floatValue();
        float[] result = new float[preds.length];
        float sum = 0.0f;
        for (i = 0; i < preds.length; ++i) {
            result[i] = (preds[i] - min.floatValue()) / range;
            sum += result[i];
        }
        if (sum > 0.0f) {
            i = 0;
            while (i < result.length) {
                int n = i++;
                result[n] = result[n] / sum;
            }
        }
        return result;
    }
}

