/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.source.AbstractArrayProvider;
import adams.ml.cntk.modelgenerator.ManualBrainScriptModel;
import adams.ml.cntk.modelgenerator.ModelGenerator;

public class CNTKModelGenerator
extends AbstractArrayProvider {
    private static final long serialVersionUID = 711203375341324288L;
    protected ModelGenerator m_ModelGenerator;
    protected int m_NumInput;
    protected int m_NumOutput;

    public String globalInfo() {
        return "Outputs the model(s) generated by the specified generator scheme.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("model-generator", "modelGenerator", (Object)new ManualBrainScriptModel());
        this.m_OptionManager.add("num-input", "numInput", (Object)1, (Number)1, null);
        this.m_OptionManager.add("num-output", "numOutput", (Object)1, (Number)1, null);
    }

    public String outputArrayTipText() {
        return "If enabled, the models are output as array rather than one-by-one.";
    }

    public void setNumInput(int value) {
        if (this.getOptionManager().isValid("numInput", (Number)value)) {
            this.m_NumInput = value;
            this.reset();
        }
    }

    public int getNumInput() {
        return this.m_NumInput;
    }

    public String numInputTipText() {
        return "The number of input nodes to use.";
    }

    public void setNumOutput(int value) {
        if (this.getOptionManager().isValid("numOutput", (Number)value)) {
            this.m_NumOutput = value;
            this.reset();
        }
    }

    public int getNumOutput() {
        return this.m_NumOutput;
    }

    public String numOutputTipText() {
        return "The number of output nodes to use.";
    }

    public void setModelGenerator(ModelGenerator value) {
        this.m_ModelGenerator = value;
        this.reset();
    }

    public ModelGenerator getModelGenerator() {
        return this.m_ModelGenerator;
    }

    public String modelGeneratorTipText() {
        return "The model generator to use for generating the actual models.";
    }

    protected Class getItemClass() {
        return String.class;
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"modelGenerator", (Object)this.m_ModelGenerator, (String)"generator: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"numInput", (Object)this.m_NumInput, (String)", input: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"numOutput", (Object)this.m_NumOutput, (String)", output: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        try {
            this.m_ModelGenerator.setFlowContext((Actor)this);
            this.m_Queue.addAll(this.m_ModelGenerator.generate(this.m_NumInput, this.m_NumOutput));
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate models!", e);
        }
        return result;
    }
}

