/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.output.CNTKSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SparseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class CNTKSpreadSheetReader
extends AbstractSpreadSheetReader
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 6732892846887308208L;

    public String globalInfo() {
        return "Reads datasets in CNTK text file format.\nFor more details, see:\n" + this.getTechnicalInformation();
    }

    public TechnicalInformation getTechnicalInformation() {
        return new CNTKSpreadSheetWriter().getTechnicalInformation();
    }

    public String getFormatDescription() {
        return new CNTKSpreadSheetWriter().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new CNTKSpreadSheetWriter().getFormatExtensions();
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new CNTKSpreadSheetWriter();
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.READER;
    }

    protected String removeComments(String line) {
        if (!line.contains("#")) {
            return line;
        }
        boolean comment = false;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '#') {
                comment = true;
            } else if (c == '|') {
                comment = false;
            }
            if (comment) continue;
            result.append(c);
        }
        return result.toString();
    }

    protected SpreadSheet doRead(Reader r) {
        DefaultSpreadSheet sheet;
        String name;
        BufferedReader breader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        SpreadSheet result = null;
        HashMap<String, DefaultSpreadSheet> sheets = null;
        boolean sparse = false;
        int lineNo = 0;
        Pattern pattID = Pattern.compile("^[0-9]+.*");
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> rowIDs = new ArrayList<String>();
        boolean hasRowIDs = false;
        try {
            String line;
            while ((line = breader.readLine()) != null && !this.isStopped()) {
                String[] sections;
                ++lineNo;
                line = this.removeComments(line);
                if (sheets == null) {
                    sheets = new HashMap<String, DefaultSpreadSheet>();
                    sparse = line.contains(":");
                }
                String rowID = null;
                if (pattID.matcher(line).matches()) {
                    hasRowIDs = true;
                    rowID = line.substring(0, line.indexOf("|")).trim();
                    line = line.substring(line.indexOf("|") + 1);
                }
                rowIDs.add(rowID);
                for (String section : sections = line.split("\\|")) {
                    boolean initHeader;
                    name = section.contains(" ") ? section.substring(0, section.indexOf(" ")).trim() : section.trim();
                    section = section.substring(name.length()).trim();
                    if (!sheets.containsKey(name)) {
                        initHeader = true;
                        sheet = new DefaultSpreadSheet();
                        sheet.setName(name);
                        names.add(name);
                        if (sparse) {
                            sheet.setDataRowClass(SparseDataRow.class);
                        }
                        sheets.put(name, sheet);
                    } else {
                        initHeader = false;
                        sheet = (SpreadSheet)sheets.get(name);
                    }
                    while (sheet.getRowCount() < lineNo) {
                        sheet.addRow();
                    }
                    if (section.isEmpty()) continue;
                    String[] cells = section.split(" ");
                    for (int i = 0; i < cells.length; ++i) {
                        double value;
                        int index;
                        if (cells[i].contains(":")) {
                            String[] parts = cells[i].split(":");
                            index = Integer.parseInt(parts[0]);
                            value = Double.parseDouble(parts[0]);
                        } else {
                            index = i;
                            value = Double.parseDouble(cells[i]);
                        }
                        if (initHeader) {
                            while (sheet.getColumnCount() - 1 < index) {
                                sheet.insertColumn(sheet.getColumnCount(), name + "-" + sheet.getColumnCount());
                            }
                        }
                        DataRow row = sheet.getRow(sheet.getRowCount() - 1);
                        row.addCell(index).setContent(Double.valueOf(value));
                    }
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read line " + lineNo + "!", (Throwable)e);
            sheets = null;
        }
        if (sheets != null) {
            if (hasRowIDs) {
                sheet = new DefaultSpreadSheet();
                sheet.setName("Row IDs");
                sheet.getHeaderRow().addCell("r").setContent("ID");
                for (String id : rowIDs) {
                    sheet.addRow().addCell("r").setContent(id);
                }
                name = "rowids-" + System.currentTimeMillis();
                names.add(0, name);
                sheets.put(name, sheet);
            }
            for (String n : names) {
                if (result == null) {
                    result = (SpreadSheet)sheets.get(n);
                    continue;
                }
                result.mergeWith((SpreadSheet)sheets.get(n));
            }
        }
        return result;
    }
}

