/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.generatefilebaseddataset;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseKeyValuePair;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.data.RoundingType;
import adams.data.SharedStringsTable;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.subimages.Grid;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.input.JAIImageReader;
import adams.data.objectfilter.Scale;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.Report;
import adams.flow.container.FileBasedDatasetContainer;
import adams.flow.transformer.generatefilebaseddataset.AbstractFileBasedDatasetGeneration;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class CNTKFasterRCNN
extends AbstractFileBasedDatasetGeneration<String> {
    private static final long serialVersionUID = 1428730724419661949L;
    public static final String SUB_DIR_TRAIN = "train";
    public static final String SUB_DIR_TEST = "test";
    public static final String SUB_DIR_NEGATIVE = "negative";
    public static final String[] SUB_DIRS = new String[]{"train", "test", "negative"};
    public static final String BACKGROUND = "__background__";
    public static final String CLASS_MAP = "class_map.txt";
    protected PlaceholderDirectory m_OutputDir;
    protected AbstractImageReader m_ImageReader;
    protected BaseRegExp m_RegExpEnlarge;
    protected ObjectFinder m_ObjectFinder;
    protected BaseKeyValuePair[] m_LabelTranslations;
    protected boolean m_OutputObjectLocations;
    protected boolean m_UseNegativeAnnotations;
    protected AbstractImageReader m_NegativeImageReader;
    protected ObjectFinder m_NegativeObjectFinder;

    public String globalInfo() {
        return "Generates a CNTK dataset for Faster-RCNN in the specified directory.\nExpects reports with annotations to be present with the same name (but with .report extension).\nVia the 'regExpEnlarge' expression, iamges can be identified that should be split into 2x2 grid and blown up to original size.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-dir", "outputDir", (Object)new PlaceholderDirectory());
        this.m_OptionManager.add("regexp-enlarge", "regExpEnlarge", (Object)new BaseRegExp(".*-2x2.*"));
        this.m_OptionManager.add("image-reader", "imageReader", (Object)new JAIImageReader());
        this.m_OptionManager.add("object-finder", "objectFinder", (Object)new AllFinder());
        this.m_OptionManager.add("label-translation", "labelTranslations", (Object)new BaseKeyValuePair[0]);
        this.m_OptionManager.add("output-object-locations", "outputObjectLocations", (Object)false);
        this.m_OptionManager.add("use-negative-annotations", "useNegativeAnnotations", (Object)false);
        this.m_OptionManager.add("negative-image-reader", "negativeImageReader", (Object)new JAIImageReader());
        this.m_OptionManager.add("negative-object-finder", "negativeObjectFinder", (Object)new AllFinder());
    }

    public void setOutputDir(PlaceholderDirectory value) {
        this.m_OutputDir = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDir() {
        return this.m_OutputDir;
    }

    public String outputDirTipText() {
        return "The output directory for the generated dataset.";
    }

    public void setRegExpEnlarge(BaseRegExp value) {
        this.m_RegExpEnlarge = value;
        this.reset();
    }

    public BaseRegExp getRegExpEnlarge() {
        return this.m_RegExpEnlarge;
    }

    public String regExpEnlargeTipText() {
        return "The regular expression for identifying train/test images that need to get enlarged (2x2 grid).";
    }

    public void setImageReader(AbstractImageReader value) {
        this.m_ImageReader = value;
        this.reset();
    }

    public AbstractImageReader getImageReader() {
        return this.m_ImageReader;
    }

    public String imageReaderTipText() {
        return "The image reader to use for the train/test images.";
    }

    public void setObjectFinder(ObjectFinder value) {
        this.m_ObjectFinder = value;
        this.reset();
    }

    public ObjectFinder getObjectFinder() {
        return this.m_ObjectFinder;
    }

    public String objectFinderTipText() {
        return "The object finder to use for the train/test annotations.";
    }

    public void setLabelTranslations(BaseKeyValuePair[] value) {
        this.m_LabelTranslations = value;
        this.reset();
    }

    public BaseKeyValuePair[] getLabelTranslations() {
        return this.m_LabelTranslations;
    }

    public String labelTranslationsTipText() {
        return "For translation labels: key=to find, value=replacement.";
    }

    public void setOutputObjectLocations(boolean value) {
        this.m_OutputObjectLocations = value;
        this.reset();
    }

    public boolean getOutputObjectLocations() {
        return this.m_OutputObjectLocations;
    }

    public String outputObjectLocationsTipText() {
        return "If enabled, the object locations and their associated label and file are output in a spreadsheet for training/test set.";
    }

    public void setUseNegativeAnnotations(boolean value) {
        this.m_UseNegativeAnnotations = value;
        this.reset();
    }

    public boolean getUseNegativeAnnotations() {
        return this.m_UseNegativeAnnotations;
    }

    public String useNegativeAnnotationsTipText() {
        return "If enabled, the located annotations of the negative images get extracted as actual negative images; if disabled, just copies the images as is into the output directory.";
    }

    public void setNegativeImageReader(AbstractImageReader value) {
        this.m_NegativeImageReader = value;
        this.reset();
    }

    public AbstractImageReader getNegativeImageReader() {
        return this.m_NegativeImageReader;
    }

    public String negativeImageReaderTipText() {
        return "The image reader to use for the negative images.";
    }

    public void setNegativeObjectFinder(ObjectFinder value) {
        this.m_NegativeObjectFinder = value;
        this.reset();
    }

    public ObjectFinder getNegativeObjectFinder() {
        return this.m_NegativeObjectFinder;
    }

    public String negativeObjectFinderTipText() {
        return "The object finder to use for the negative annotations.";
    }

    public Class generates() {
        return String.class;
    }

    protected String[] requiredValues() {
        return new String[]{"Train", "Test", "Negative"};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"objectFinder", (Object)this.m_ObjectFinder, (String)", finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputDir", (Object)this.m_OutputDir, (String)", output: ");
        if (this.m_UseNegativeAnnotations) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"negativeImageReader", (Object)this.m_NegativeImageReader, (String)", neg image reader: ");
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"negativeObjectFinder", (Object)this.m_NegativeObjectFinder, (String)", neg finder: ");
        }
        return result;
    }

    protected String check(FileBasedDatasetContainer cont) {
        String result = super.check(cont);
        if (result == null && this.m_OutputDir.exists()) {
            if (!this.m_OutputDir.isDirectory()) {
                result = "Already exists, but isn't a directory: " + this.m_OutputDir;
            } else {
                String[] files = this.m_OutputDir.list();
                if (files != null) {
                    for (String file : files) {
                        if (file.equals(".") || file.equals("..")) continue;
                        result = "Output directory is non-empty: " + this.m_OutputDir;
                        break;
                    }
                }
            }
        }
        return result;
    }

    protected String translateLabel(String label) {
        String result = label;
        if (this.m_LabelTranslations.length > 0) {
            for (BaseKeyValuePair translation : this.m_LabelTranslations) {
                if (!translation.getPairKey().equals(result)) continue;
                result = translation.getPairValue();
            }
        }
        return result;
    }

    protected String createDirStructure() {
        String result = null;
        for (String subdir : SUB_DIRS) {
            PlaceholderDirectory dir = new PlaceholderDirectory(this.m_OutputDir.getAbsolutePath() + File.separator + subdir);
            if (dir.mkdirs()) continue;
            result = "Failed to create sub-directory: " + dir;
            break;
        }
        return result;
    }

    protected Report readAssociatedReport(String file) {
        String[] reportFiles;
        Report result = null;
        DefaultSimpleReportReader reader = new DefaultSimpleReportReader();
        for (String reportFile : reportFiles = new String[]{FileUtils.replaceExtension((String)file, (String)".report"), FileUtils.replaceExtension((String)file, (String)".report.gz")}) {
            if (!FileUtils.fileExists((String)reportFile)) continue;
            reader.setInput(new PlaceholderFile(reportFile));
            List reports = reader.read();
            if (reports == null || reports.size() <= 0) break;
            result = (Report)reports.get(0);
            break;
        }
        return result;
    }

    protected BufferedImageContainer[] enlarge(AbstractImageContainer imgCont) {
        ArrayList<BufferedImageContainer> result = new ArrayList<BufferedImageContainer>();
        Grid grid = new Grid();
        grid.setNumCols(2);
        grid.setNumRows(2);
        grid.setPartial(false);
        grid.setFixInvalid(true);
        grid.setPrefix(this.m_ObjectFinder.getPrefix());
        List subImages = grid.process(BufferedImageHelper.toBufferedImageContainer((AbstractImageContainer)imgCont));
        for (BufferedImageContainer subImage : subImages) {
            ParameterBlock params = new ParameterBlock();
            params.addSource(subImage.toBufferedImage());
            params.add(2.0f);
            params.add(2.0f);
            params.add(0.0f);
            params.add(0.0f);
            params.add(new InterpolationNearest());
            RenderedOp imNew = JAI.create((String)"scale", (ParameterBlock)params);
            BufferedImageContainer contNew = new BufferedImageContainer();
            contNew.setContent((Object)imNew.getAsBufferedImage());
            LocatedObjects objects = LocatedObjects.fromReport((Report)subImage.getReport(), (String)this.m_ObjectFinder.getPrefix());
            Scale scale = new Scale();
            scale.setScaleX(2.0);
            scale.setScaleY(2.0);
            scale.setRoundingType(RoundingType.ROUND);
            objects = scale.filter(objects);
            contNew.setReport(objects.toReport(this.m_ObjectFinder.getPrefix()));
            result.add(contNew);
        }
        return result.toArray(new BufferedImageContainer[0]);
    }

    protected String processAnnotations(FileBasedDatasetContainer cont, boolean train, SharedStringsTable labels) {
        String result = null;
        String[] files = (String[])cont.getValue(train ? "Train" : "Test", String[].class);
        PlaceholderDirectory outDir = new PlaceholderDirectory(this.m_OutputDir.getAbsolutePath() + File.separator + (train ? SUB_DIR_TRAIN : SUB_DIR_TEST));
        ArrayList<String> imgList = new ArrayList<String>();
        ArrayList<String> roiList = new ArrayList<String>();
        ArrayList<String> objList = new ArrayList<String>();
        objList.add("file,x0,y0,x1,y1,label");
        int imgIndex = 0;
        for (int i = 0; i < files.length; ++i) {
            PlaceholderFile file = new PlaceholderFile(files[i]);
            boolean enlarge = this.m_RegExpEnlarge.isMatch(files[i]);
            try {
                LocatedObjects objects;
                StringBuilder rois;
                Report report = this.readAssociatedReport(file.getAbsolutePath());
                if (report == null) {
                    result = "Failed to read associated report for " + (train ? "training" : SUB_DIR_TEST) + " image: " + file;
                    break;
                }
                AbstractImageContainer imgCont = this.m_ImageReader.read(file);
                if (imgCont == null) {
                    result = "Failed to read " + (train ? "training" : SUB_DIR_TEST) + " image: " + file;
                    break;
                }
                imgCont.getReport().mergeWith(report);
                if (enlarge) {
                    BufferedImageContainer[] imgLarge = this.enlarge(imgCont);
                    for (int n = 0; n < imgLarge.length; ++n) {
                        PlaceholderFile subfile = new PlaceholderFile(outDir.getAbsolutePath() + File.separator + FileUtils.replaceExtension((String)file.getName(), (String)("-" + (n + 1) + ".png")));
                        result = BufferedImageHelper.write((BufferedImage)imgLarge[n].toBufferedImage(), (File)subfile);
                        if (result != null) break;
                        rois = new StringBuilder();
                        objects = this.m_ObjectFinder.findObjects(imgLarge[n].getReport());
                        if (objects.size() > 0) {
                            for (LocatedObject object : objects) {
                                object.makeFit(imgLarge[n].getWidth(), imgLarge[n].getHeight());
                                rois.append(" " + object.getX());
                                rois.append(" " + object.getY());
                                rois.append(" " + (object.getX() + object.getWidth() - 1));
                                rois.append(" " + (object.getY() + object.getHeight() - 1));
                                rois.append(" " + labels.getIndex(this.translateLabel("" + object.getMetaData().get("type"))));
                                if (!this.m_OutputObjectLocations) continue;
                                objList.add(FileUtils.replaceExtension((String)subfile.getName(), (String)"") + "," + object.getX() + "," + object.getY() + "," + (object.getX() + object.getWidth() - 1) + "," + (object.getY() + object.getHeight() - 1) + "," + this.translateLabel("" + object.getMetaData().get("type")));
                            }
                        }
                        imgList.add(imgIndex + "\t" + (train ? SUB_DIR_TRAIN : SUB_DIR_TEST) + "/" + subfile.getName() + "\t0");
                        roiList.add(imgIndex + " |roiAndLabel " + rois);
                        ++imgIndex;
                    }
                    if (result == null) continue;
                    break;
                }
                if (!FileUtils.copy((File)file, (File)outDir)) {
                    result = "Failed to copy image '" + file + "' to: " + outDir;
                    break;
                }
                rois = new StringBuilder();
                objects = this.m_ObjectFinder.findObjects(imgCont.getReport());
                if (objects.size() > 0) {
                    for (LocatedObject object : objects) {
                        object.makeFit(imgCont.getWidth(), imgCont.getHeight());
                        rois.append(" " + object.getX());
                        rois.append(" " + object.getY());
                        rois.append(" " + (object.getX() + object.getWidth() - 1));
                        rois.append(" " + (object.getY() + object.getHeight() - 1));
                        rois.append(" " + labels.getIndex(this.translateLabel("" + object.getMetaData().get("type"))));
                        if (!this.m_OutputObjectLocations) continue;
                        objList.add(FileUtils.replaceExtension((String)file.getName(), (String)"") + "," + object.getX() + "," + object.getY() + "," + (object.getX() + object.getWidth() - 1) + "," + (object.getY() + object.getHeight() - 1) + "," + this.translateLabel("" + object.getMetaData().get("type")));
                    }
                }
                imgList.add(imgIndex + "\t" + (train ? SUB_DIR_TRAIN : SUB_DIR_TEST) + "/" + file.getName() + "\t0");
                roiList.add(imgIndex + " |roiAndLabel " + rois);
                ++imgIndex;
                continue;
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to process " + (train ? "training" : SUB_DIR_TEST) + " '" + file + "!"), (Throwable)e);
            }
        }
        if (result == null) {
            result = FileUtils.saveToFileMsg(imgList, (File)new File(this.m_OutputDir.getAbsolutePath() + File.separator + (train ? SUB_DIR_TRAIN : SUB_DIR_TEST) + "_img_file.txt"), null);
            if (result == null) {
                result = FileUtils.saveToFileMsg(roiList, (File)new File(this.m_OutputDir.getAbsolutePath() + File.separator + (train ? SUB_DIR_TRAIN : SUB_DIR_TEST) + "_roi_file.txt"), null);
            }
            if (result == null && this.m_OutputObjectLocations) {
                result = FileUtils.saveToFileMsg(objList, (File)new File(this.m_OutputDir.getAbsolutePath() + File.separator + (train ? SUB_DIR_TRAIN : SUB_DIR_TEST) + ".csv"), null);
            }
        }
        return result;
    }

    protected String processNegative(FileBasedDatasetContainer cont) {
        String result = null;
        String[] files = (String[])cont.getValue("Negative", String[].class);
        PlaceholderDirectory outDir = new PlaceholderDirectory(this.m_OutputDir.getAbsolutePath() + File.separator + SUB_DIR_NEGATIVE);
        if (this.m_UseNegativeAnnotations) {
            block4: for (String fileStr : files) {
                PlaceholderFile file = new PlaceholderFile(fileStr);
                try {
                    Report report = this.readAssociatedReport(fileStr);
                    if (report == null) {
                        result = "Failed to read associated report for negative image: " + file;
                        break;
                    }
                    AbstractImageContainer imgCont = this.m_NegativeImageReader.read(file);
                    if (imgCont == null) {
                        result = "Failed to read negative image: " + file;
                        break;
                    }
                    LocatedObjects objects = this.m_NegativeObjectFinder.findObjects(report);
                    if (objects.size() <= 0) continue;
                    BufferedImage img = imgCont.toBufferedImage();
                    int count = 0;
                    for (LocatedObject object : objects) {
                        String subFile;
                        object.makeFit(img.getWidth(), img.getHeight());
                        BufferedImage subImg = img.getSubimage(object.getX(), object.getY(), object.getWidth(), object.getHeight());
                        result = BufferedImageHelper.write((BufferedImage)subImg, (File)new PlaceholderFile(subFile = this.m_OutputDir.getAbsolutePath() + File.separator + SUB_DIR_NEGATIVE + File.separator + FileUtils.replaceExtension((String)file.getName(), (String)("-" + ++count + ".png"))));
                        if (result == null) continue;
                        continue block4;
                    }
                }
                catch (Exception e) {
                    result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to extract negative regions from '" + file + "' to: " + outDir), (Throwable)e);
                }
            }
        } else {
            try {
                for (String fileStr : files) {
                    if (FileUtils.copy((File)new PlaceholderFile(fileStr), (File)outDir)) continue;
                    result = "Failed to copy '" + fileStr + "' to: " + outDir;
                }
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to copy negative images to: " + outDir), (Throwable)e);
            }
        }
        return result;
    }

    protected String processClassMap(SharedStringsTable labels) {
        String result = null;
        if (labels.size() == 0) {
            result = "No labels collected!";
        }
        if (result == null) {
            ArrayList<String> content = new ArrayList<String>();
            for (int i = 0; i < labels.size(); ++i) {
                content.add(labels.getString(i) + "\t" + i);
            }
            result = FileUtils.saveToFileMsg(content, (File)new File(this.m_OutputDir.getAbsolutePath() + File.separator + CLASS_MAP), null);
        }
        return result;
    }

    protected String doGenerate(FileBasedDatasetContainer cont) {
        String msg = this.createDirStructure();
        if (msg == null) {
            SharedStringsTable labels = new SharedStringsTable();
            labels.getIndex(BACKGROUND);
            msg = this.processAnnotations(cont, true, labels);
            if (msg == null) {
                msg = this.processAnnotations(cont, false, labels);
            }
            if (msg == null) {
                msg = this.processNegative(cont);
            }
            if (msg == null) {
                msg = this.processClassMap(labels);
            }
        }
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.m_OutputDir.getAbsolutePath();
    }
}

