/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.cntk.modelgenerator;

import adams.core.base.BaseText;
import adams.ml.cntk.modelgenerator.AbstractBrainScriptModelGenerator;
import java.util.ArrayList;
import java.util.List;

public class ManualBrainScriptModel
extends AbstractBrainScriptModelGenerator {
    private static final long serialVersionUID = -4683549348343064989L;
    public static final String INPUT_DIM = "inputDim";
    public static final String OUTPUT_DIM = "outputDim";
    protected BaseText m_Script;

    public String globalInfo() {
        return "Just outputs a single, manually defined BrainScript model.\nInserts the following variables for input and output dimensions:\n- input: inputDim\n- output: outputDim\n\n" + this.getBrainScriptInfo();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "script", (Object)new BaseText("model = Sequential (\n  Scale {featScale} :\n  DenseLayer  {inputDim, init=\"gaussian\", initValueScale=1.5} : Dropout: ReLU : \n  DenseLayer  {512, init=\"gaussian\", initValueScale=1.5} : Dropout: ReLU : \n  DenseLayer  {256, init=\"gaussian\", initValueScale=1.5} : Dropout: ReLU :  \n  LinearLayer {outputDim}\n)\n\nSGD = {\n  maxEpochs = 100\n  dropoutRate = 0\n  minibatchSize = 256\n}\n"));
    }

    public void setScript(BaseText value) {
        this.m_Script = value;
        this.reset();
    }

    public BaseText getScript() {
        return this.m_Script;
    }

    public String scriptTipText() {
        return "The script to output.";
    }

    @Override
    protected List<String> doGenerate(int numInput, int numOutput) {
        ArrayList<String> result = new ArrayList<String>();
        String script = this.m_FlowContext.getVariables().expand(this.m_Script.getValue());
        String model = "inputDim = " + numInput + "\n" + OUTPUT_DIM + " = " + numOutput + "\n\n" + script;
        if (!model.endsWith("\n")) {
            model = model + "\n";
        }
        result.add(model);
        return result;
    }
}

