/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.base.BaseRegExp;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class TarUtils {
    public static Compression determineCompression(File archive) {
        return TarUtils.determineCompression(archive.getAbsolutePath());
    }

    public static Compression determineCompression(String archive) {
        if ((archive = archive.toLowerCase()).endsWith(".tar.gz")) {
            return Compression.GZIP;
        }
        if (archive.endsWith(".tgz")) {
            return Compression.GZIP;
        }
        if (archive.endsWith(".tar.bz2")) {
            return Compression.BZIP2;
        }
        return Compression.NONE;
    }

    protected static TarArchiveInputStream openArchiveForReading(File input) throws Exception {
        Compression comp = TarUtils.determineCompression(input);
        if (comp == Compression.GZIP) {
            return new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(input.getAbsoluteFile()))));
        }
        if (comp == Compression.BZIP2) {
            return new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(input.getAbsoluteFile()))));
        }
        return new TarArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(input.getAbsoluteFile())));
    }

    protected static TarArchiveOutputStream openArchiveForWriting(File input) throws Exception {
        Compression comp = TarUtils.determineCompression(input);
        TarArchiveOutputStream result = comp == Compression.GZIP ? new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(input.getAbsoluteFile())))) : (comp == Compression.BZIP2 ? new TarArchiveOutputStream((OutputStream)new BZip2CompressorOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(input.getAbsoluteFile())))) : new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(input.getAbsoluteFile()))));
        result.setLongFileMode(2);
        return result;
    }

    public static String compress(File output, File[] files) {
        return TarUtils.compress(output, files, 1024);
    }

    public static String compress(File output, File[] files, int bufferSize) {
        return TarUtils.compress(output, files, "", bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(author="Jeremy Whitlock (jcscoobyrs)", copyright="2010 Jeremy Whitlock", license=License.APACHE2, url="http://www.thoughtspark.org/node/53")
    public static String compress(File output, File[] files, String stripRegExp, int bufferSize) {
        BufferedInputStream in = null;
        TarArchiveOutputStream out = null;
        String result = null;
        try {
            if (output.exists()) {
                System.err.println("WARNING: overwriting '" + output + "'!");
            }
            byte[] buf = new byte[bufferSize];
            out = TarUtils.openArchiveForWriting(output);
            for (int i = 0; i < files.length; ++i) {
                int len;
                in = new BufferedInputStream(new FileInputStream(files[i].getAbsolutePath()));
                String filename = files[i].getParentFile().getAbsolutePath();
                if (stripRegExp.length() > 0) {
                    filename = filename.replaceFirst(stripRegExp, "");
                }
                if (filename.length() > 0) {
                    filename = filename + File.separator;
                }
                filename = filename + files[i].getName();
                TarArchiveEntry entry = new TarArchiveEntry(filename);
                if (files[i].isFile()) {
                    entry.setSize(files[i].length());
                }
                out.putArchiveEntry((ArchiveEntry)entry);
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeArchiveEntry();
                in.close();
                in = null;
            }
            out.close();
            out = null;
        }
        catch (Exception e) {
            String msg = "Failed to generate archive '" + output + "': ";
            System.err.println(msg);
            e.printStackTrace();
            result = msg + e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static Vector<File> decompress(File input, File outputDir) {
        return TarUtils.decompress(input, outputDir, false);
    }

    public static Vector<File> decompress(File input, File outputDir, boolean createDirs) {
        return TarUtils.decompress(input, outputDir, createDirs, new BaseRegExp(""), false);
    }

    public static Vector<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch) {
        return TarUtils.decompress(input, outputDir, createDirs, match, invertMatch, 1024);
    }

    public static Vector<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch, int bufferSize) {
        return TarUtils.decompress(input, outputDir, createDirs, match, invertMatch, bufferSize, new StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch, int bufferSize, StringBuilder errors) {
        Vector<File> result = new Vector<File>();
        TarArchiveInputStream archive = null;
        try {
            TarArchiveEntry entry;
            byte[] buffer = new byte[bufferSize];
            archive = TarUtils.openArchiveForReading(input.getAbsoluteFile());
            while ((entry = archive.getNextTarEntry()) != null) {
                String error;
                File outFile;
                if (entry.isDirectory() && !createDirs || !match.isMatchAll() && !match.isEmpty() && (invertMatch && match.isMatch(entry.getName()) || !invertMatch && !match.isMatch(entry.getName()))) continue;
                if (entry.isDirectory() && createDirs) {
                    outFile = new File(outputDir.getAbsolutePath() + File.separator + entry.getName());
                    if (outFile.mkdirs()) continue;
                    error = "Failed to create directory '" + outFile.getAbsolutePath() + "'!";
                    System.err.println(error);
                    errors.append(error + "\n");
                    continue;
                }
                BufferedOutputStream out = null;
                String outName = null;
                try {
                    int len;
                    outName = outputDir.getAbsolutePath() + File.separator;
                    outName = createDirs ? outName + entry.getName() : outName + new File(entry.getName()).getName();
                    outFile = new File(outName).getParentFile();
                    if (!outFile.exists() && !outFile.mkdirs()) {
                        error = "Failed to create directory '" + outFile.getAbsolutePath() + "', " + "skipping extraction of '" + outName + "'!";
                        System.err.println(error);
                        errors.append(error + "\n");
                        continue;
                    }
                    out = new BufferedOutputStream(new FileOutputStream(outName), bufferSize);
                    long size = entry.getSize();
                    for (long read = 0L; read < size; read += (long)len) {
                        len = archive.read(buffer);
                        out.write(buffer, 0, len);
                    }
                    result.add(new File(outName));
                }
                catch (Exception e) {
                    error = "Error extracting '" + entry.getName() + "' to '" + outName + "': " + e;
                    System.err.println(error);
                    errors.append(error + "\n");
                }
                finally {
                    if (out == null) continue;
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errors.append("Error occurred: " + e + "\n");
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static boolean decompress(File input, String archiveFile, File output) {
        return TarUtils.decompress(input, archiveFile, output, false);
    }

    public static boolean decompress(File input, String archiveFile, File output, boolean createDirs) {
        return TarUtils.decompress(input, archiveFile, output, createDirs, 1024, new StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompress(File input, String archiveFile, File output, boolean createDirs, int bufferSize, StringBuilder errors) {
        boolean result = false;
        TarArchiveInputStream archive = null;
        try {
            TarArchiveEntry entry;
            byte[] buffer = new byte[bufferSize];
            archive = TarUtils.openArchiveForReading(input.getAbsoluteFile());
            while ((entry = archive.getNextTarEntry()) != null) {
                String error;
                if (entry.isDirectory() || !entry.getName().equals(archiveFile)) continue;
                BufferedOutputStream out = null;
                String outName = null;
                try {
                    int len;
                    outName = output.getAbsolutePath();
                    File outFile = new File(outName).getParentFile();
                    if (!outFile.exists()) {
                        if (!createDirs) {
                            error = "Output directory '" + outFile.getAbsolutePath() + " does not exist', " + "skipping extraction of '" + outName + "'!";
                            System.err.println(error);
                            errors.append(error + "\n");
                            break;
                        }
                        if (!outFile.mkdirs()) {
                            error = "Failed to create directory '" + outFile.getAbsolutePath() + "', " + "skipping extraction of '" + outName + "'!";
                            System.err.println(error);
                            errors.append(error + "\n");
                            break;
                        }
                    }
                    out = new BufferedOutputStream(new FileOutputStream(outName), bufferSize);
                    long size = entry.getSize();
                    for (long read = 0L; read < size; read += (long)len) {
                        len = archive.read(buffer);
                        out.write(buffer, 0, len);
                    }
                    result = true;
                }
                catch (Exception e) {
                    result = false;
                    error = "Error extracting '" + entry.getName() + "' to '" + outName + "': " + e;
                    System.err.println(error);
                    errors.append(error + "\n");
                }
                finally {
                    if (out == null) continue;
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            errors.append("Error occurred: " + e + "\n");
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static Vector<File> listFiles(File input) {
        return TarUtils.listFiles(input, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<File> listFiles(File input, boolean listDirs) {
        Vector<File> result = new Vector<File>();
        TarArchiveInputStream archive = null;
        try {
            TarArchiveEntry entry;
            archive = TarUtils.openArchiveForReading(input);
            while ((entry = archive.getNextTarEntry()) != null) {
                if (entry.isDirectory() && listDirs) {
                    result.add(new File(entry.getName()));
                    continue;
                }
                result.add(new File(entry.getName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static enum Compression {
        AUTO,
        NONE,
        GZIP,
        BZIP2;

    }
}

