/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public abstract class AbstractMultiCompress
extends AbstractTransformer {
    private static final long serialVersionUID = -4546660303745271704L;
    protected PlaceholderFile m_Output;
    protected String m_StripPath;
    protected int m_BufferSize;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "output", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("strip-path", "stripPath", (Object)"");
        this.m_OptionManager.add("buffer", "bufferSize", (Object)1024);
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value;
        this.reset();
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public abstract String outputTipText();

    public void setStripPath(String value) {
        this.m_StripPath = value;
        this.reset();
    }

    public String getStripPath() {
        return this.m_StripPath;
    }

    public String stripPathTipText() {
        return "The regular expression for stripping the path (use '.*' to remove the path completely).";
    }

    public void setBufferSize(int value) {
        this.m_BufferSize = value;
        this.reset();
    }

    public int getBufferSize() {
        return this.m_BufferSize;
    }

    public String bufferSizeTipText() {
        return "The size of the buffer in bytes for the data stream.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("output");
        if (variable != null) {
            return variable;
        }
        if (this.m_Output != null) {
            return this.m_Output.toString();
        }
        return null;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class, String[].class, File[].class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected abstract String compress(File[] var1);

    protected String doExecute() {
        String result = null;
        File[] inFiles = null;
        if (this.m_InputToken.getPayload() instanceof File) {
            inFiles = new File[]{(File)this.m_InputToken.getPayload()};
        } else if (this.m_InputToken.getPayload() instanceof File[]) {
            inFiles = (File[])this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof String) {
            inFiles = new File[]{new PlaceholderFile((String)this.m_InputToken.getPayload())};
        } else if (this.m_InputToken.getPayload() instanceof String[]) {
            inFiles = new File[((String[])this.m_InputToken.getPayload()).length];
            for (int i = 0; i < inFiles.length; ++i) {
                inFiles[i] = new PlaceholderFile(((String[])this.m_InputToken.getPayload())[i]);
            }
        }
        result = this.compress(inFiles);
        if (result == null) {
            this.m_OutputToken = new Token((Object)this.m_Output.getAbsolutePath());
        }
        return result;
    }
}

