/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.transformer.ArrayToSequence;
import adams.flow.transformer.Lzma;
import adams.flow.transformer.TextFileReader;
import adams.flow.transformer.UnLzma;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class LzmaTest
extends AbstractFlowTest {
    public LzmaTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("external_standalone.flow");
        this.m_TestHelper.deleteFileFromTmp("external_standalone.flow.7z");
        this.m_TestHelper.deleteFileFromTmp("external_standalone2.flow");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.flow");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("external_standalone.flow");
        this.m_TestHelper.deleteFileFromTmp("external_standalone.flow.7z");
        this.m_TestHelper.deleteFileFromTmp("external_standalone2.flow");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.flow");
        super.tearDown();
    }

    public AbstractActor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("${TMP}/external_standalone.flow")});
        Lzma zip = new Lzma();
        UnLzma unzip = new UnLzma();
        unzip.setAlternativeFilename("external_standalone2.flow");
        TextFileReader tfr = new TextFileReader();
        ArrayToSequence a2s = new ArrayToSequence();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.flow"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sc, zip, unzip, tfr, a2s, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.flow"));
    }

    public static Test suite() {
        return new TestSuite(LzmaTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        LzmaTest.runTest((Test)LzmaTest.suite());
    }
}

