/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.PlaceholderFile;
import com.ning.compress.lzf.LZFInputStream;
import com.ning.compress.lzf.LZFOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class LzfUtils {
    public static final String EXTENSION = ".lzf";

    public static String decompress(File archiveFile, int buffer) {
        return LzfUtils.decompress(archiveFile, buffer, (File)new PlaceholderFile(archiveFile.getAbsolutePath().replaceAll("\\.lzf$", "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(File archiveFile, int buffer, File outputFile) {
        LZFInputStream in = null;
        OutputStream out = null;
        String result = null;
        try {
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            in = new LZFInputStream((InputStream)new FileInputStream(archiveFile.getAbsolutePath()));
            out = new BufferedOutputStream(new FileOutputStream(outputFile.getAbsolutePath()));
            IOUtils.copy((InputStream)in, (OutputStream)out, (int)buffer);
            out.close();
            out = null;
            in.close();
            in = null;
        }
        catch (Exception e) {
            String msg = "Failed to decompress '" + archiveFile + "': ";
            System.err.println(msg);
            e.printStackTrace();
            result = msg + e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static String compress(File inputFile, int buffer) {
        return LzfUtils.compress(inputFile, buffer, (File)new PlaceholderFile(inputFile.getAbsolutePath() + EXTENSION));
    }

    public static String compress(File inputFile, int buffer, File outputFile) {
        return LzfUtils.compress(inputFile, buffer, outputFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compress(File inputFile, int buffer, File outputFile, boolean removeInput) {
        BufferedInputStream in = null;
        LZFOutputStream out = null;
        String result = null;
        try {
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            in = new BufferedInputStream(new FileInputStream(inputFile.getAbsolutePath()));
            out = new LZFOutputStream((OutputStream)new FileOutputStream(outputFile.getAbsolutePath()));
            IOUtils.copy((InputStream)in, (OutputStream)out, (int)buffer);
            in.close();
            in = null;
            out.close();
            out = null;
            if (removeInput && !inputFile.delete()) {
                result = "Failed to delete input file '" + inputFile + "' after successful compression!";
            }
        }
        catch (Exception e) {
            String msg = "Failed to compress '" + inputFile + "': ";
            System.err.println(msg);
            e.printStackTrace();
            result = msg + e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }
}

