/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.base.BaseRegExp;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipUtils {
    public static String compress(File output, File[] files) {
        return ZipUtils.compress(output, files, 1024);
    }

    public static String compress(File output, File[] files, int bufferSize) {
        return ZipUtils.compress(output, files, "", bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(copyright="Apache compress commons", license=License.APACHE2, url="http://commons.apache.org/compress/examples.html")
    public static String compress(File output, File[] files, String stripRegExp, int bufferSize) {
        BufferedInputStream in = null;
        ZipArchiveOutputStream out = null;
        String result = null;
        try {
            if (output.exists()) {
                System.err.println("WARNING: overwriting '" + output + "'!");
            }
            byte[] buf = new byte[bufferSize];
            out = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(output.getAbsolutePath())));
            for (int i = 0; i < files.length; ++i) {
                int len;
                in = new BufferedInputStream(new FileInputStream(files[i].getAbsolutePath()));
                String filename = files[i].getParentFile().getAbsolutePath();
                if (stripRegExp.length() > 0) {
                    filename = filename.replaceFirst(stripRegExp, "");
                }
                if (filename.length() > 0) {
                    filename = filename + File.separator;
                }
                filename = filename + files[i].getName();
                ZipArchiveEntry entry = new ZipArchiveEntry(filename);
                entry.setSize(files[i].length());
                out.putArchiveEntry((ArchiveEntry)entry);
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeArchiveEntry();
                in.close();
                in = null;
            }
            out.close();
            out = null;
        }
        catch (Exception e) {
            String msg = "Failed to generate archive '" + output + "': ";
            System.err.println(msg);
            e.printStackTrace();
            result = msg + e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static List<File> decompress(File input, File outputDir) {
        return ZipUtils.decompress(input, outputDir, false);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs) {
        return ZipUtils.decompress(input, outputDir, createDirs, new BaseRegExp(""), false);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch) {
        return ZipUtils.decompress(input, outputDir, createDirs, match, invertMatch, 1024);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch, int bufferSize) {
        return ZipUtils.decompress(input, outputDir, createDirs, match, invertMatch, bufferSize, new StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(copyright="Apache compress commons", license=License.APACHE2, url="http://commons.apache.org/compress/examples.html")
    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch, int bufferSize, StringBuilder errors) {
        ArrayList<File> result = new ArrayList<File>();
        ZipFile archive = null;
        try {
            byte[] buffer = new byte[bufferSize];
            archive = new ZipFile(input.getAbsoluteFile());
            Enumeration enm = archive.getEntries();
            while (enm.hasMoreElements()) {
                String error;
                File outFile;
                ZipArchiveEntry entry = (ZipArchiveEntry)enm.nextElement();
                if (entry.isDirectory() && !createDirs || !match.isMatchAll() && !match.isEmpty() && (invertMatch && match.isMatch(entry.getName()) || !invertMatch && !match.isMatch(entry.getName()))) continue;
                if (entry.isDirectory() && createDirs) {
                    outFile = new File(outputDir.getAbsolutePath() + File.separator + entry.getName());
                    if (outFile.mkdirs()) continue;
                    error = "Failed to create directory '" + outFile.getAbsolutePath() + "'!";
                    System.err.println(error);
                    errors.append(error + "\n");
                    continue;
                }
                BufferedInputStream in = null;
                BufferedOutputStream out = null;
                String outName = null;
                try {
                    int len;
                    outName = outputDir.getAbsolutePath() + File.separator;
                    outName = createDirs ? outName + entry.getName() : outName + new File(entry.getName()).getName();
                    outFile = new File(outName).getParentFile();
                    if (!outFile.exists() && !outFile.mkdirs()) {
                        error = "Failed to create directory '" + outFile.getAbsolutePath() + "', " + "skipping extraction of '" + outName + "'!";
                        System.err.println(error);
                        errors.append(error + "\n");
                        continue;
                    }
                    in = new BufferedInputStream(archive.getInputStream(entry));
                    out = new BufferedOutputStream(new FileOutputStream(outName), bufferSize);
                    for (long read = 0L; read < entry.getSize(); read += (long)len) {
                        len = in.read(buffer);
                        out.write(buffer, 0, len);
                    }
                    result.add(new File(outName));
                }
                catch (Exception e) {
                    error = "Error extracting '" + entry.getName() + "' to '" + outName + "': " + e;
                    System.err.println(error);
                    errors.append(error + "\n");
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {}
                    }
                    if (out == null) continue;
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errors.append("Error occurred: " + e + "\n");
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static boolean decompress(File input, String archiveFile, File output) {
        return ZipUtils.decompress(input, archiveFile, output, false);
    }

    public static boolean decompress(File input, String archiveFile, File output, boolean createDirs) {
        return ZipUtils.decompress(input, archiveFile, output, createDirs, 1024, new StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean decompress(File input, String archiveFile, File output, boolean createDirs, int bufferSize, StringBuilder errors) {
        boolean result = false;
        ZipFile zipfile = null;
        try {
            byte[] buffer = new byte[bufferSize];
            zipfile = new ZipFile(input.getAbsoluteFile());
            Enumeration enm = zipfile.getEntries();
            while (enm.hasMoreElements()) {
                String error;
                ZipArchiveEntry entry = (ZipArchiveEntry)enm.nextElement();
                if (entry.isDirectory() || !entry.getName().equals(archiveFile)) continue;
                BufferedInputStream in = null;
                BufferedOutputStream out = null;
                String outName = null;
                try {
                    int len;
                    outName = output.getAbsolutePath();
                    File outFile = new File(outName).getParentFile();
                    if (!outFile.exists()) {
                        if (!createDirs) {
                            error = "Output directory '" + outFile.getAbsolutePath() + " does not exist', " + "skipping extraction of '" + outName + "'!";
                            System.err.println(error);
                            errors.append(error + "\n");
                            return result;
                        }
                        if (!outFile.mkdirs()) {
                            error = "Failed to create directory '" + outFile.getAbsolutePath() + "', " + "skipping extraction of '" + outName + "'!";
                            System.err.println(error);
                            errors.append(error + "\n");
                            return result;
                        }
                    }
                    in = new BufferedInputStream(zipfile.getInputStream(entry));
                    out = new BufferedOutputStream(new FileOutputStream(outName), bufferSize);
                    for (long read = 0L; read < entry.getSize(); read += (long)len) {
                        len = in.read(buffer);
                        out.write(buffer, 0, len);
                    }
                    result = true;
                    return result;
                }
                catch (Exception e) {
                    result = false;
                    error = "Error extracting '" + entry.getName() + "' to '" + outName + "': " + e;
                    System.err.println(error);
                    errors.append(error + "\n");
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {}
                    }
                    if (out == null) continue;
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {}
                }
            }
            return result;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            errors.append("Error occurred: " + e + "\n");
            return result;
        }
        finally {
            if (zipfile != null) {
                try {
                    zipfile.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static List<File> listFiles(File input) {
        return ZipUtils.listFiles(input, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> listFiles(File input, boolean listDirs) {
        ArrayList<File> result = new ArrayList<File>();
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(input.getAbsoluteFile());
            Enumeration enm = zipfile.getEntries();
            while (enm.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)enm.nextElement();
                if (entry.isDirectory() && listDirs) {
                    result.add(new File(entry.getName()));
                    continue;
                }
                result.add(new File(entry.getName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (zipfile != null) {
                try {
                    zipfile.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }
}

