/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import com.ning.compress.lzf.LZFInputStream;
import com.ning.compress.lzf.LZFOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class LzfUtils {
    public static final String EXTENSION = ".lzf";

    public static String decompress(File archiveFile, int buffer) {
        return LzfUtils.decompress(archiveFile, buffer, (File)new PlaceholderFile(archiveFile.getAbsolutePath().replaceAll("\\.lzf$", "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(File archiveFile, int buffer, File outputFile) {
        LZFInputStream in = null;
        FileInputStream fis = null;
        BufferedOutputStream out = null;
        FileOutputStream fos = null;
        String result = null;
        try {
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            fis = new FileInputStream(archiveFile.getAbsolutePath());
            in = new LZFInputStream((InputStream)fis);
            fos = new FileOutputStream(outputFile.getAbsolutePath());
            out = new BufferedOutputStream(fos);
            IOUtils.copy((InputStream)in, (OutputStream)out, (int)buffer);
        }
        catch (Exception e) {
            try {
                String msg = "Failed to decompress '" + archiveFile + "': ";
                System.err.println(msg);
                e.printStackTrace();
                result = msg + e;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(in);
                FileUtils.closeQuietly(fis);
                FileUtils.closeQuietly(out);
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)in);
            FileUtils.closeQuietly((InputStream)fis);
            FileUtils.closeQuietly((OutputStream)out);
            FileUtils.closeQuietly((OutputStream)fos);
        }
        FileUtils.closeQuietly((InputStream)in);
        FileUtils.closeQuietly((InputStream)fis);
        FileUtils.closeQuietly((OutputStream)out);
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }

    public static String compress(File inputFile, int buffer) {
        return LzfUtils.compress(inputFile, buffer, (File)new PlaceholderFile(inputFile.getAbsolutePath() + EXTENSION));
    }

    public static String compress(File inputFile, int buffer, File outputFile) {
        return LzfUtils.compress(inputFile, buffer, outputFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compress(File inputFile, int buffer, File outputFile, boolean removeInput) {
        String result;
        FileOutputStream fos;
        LZFOutputStream out;
        FileInputStream fis;
        BufferedInputStream in;
        block5: {
            in = null;
            fis = null;
            out = null;
            fos = null;
            result = null;
            try {
                if (outputFile.exists()) {
                    System.err.println("WARNING: overwriting '" + outputFile + "'!");
                }
                fis = new FileInputStream(inputFile.getAbsolutePath());
                in = new BufferedInputStream(fis);
                fos = new FileOutputStream(outputFile.getAbsolutePath());
                out = new LZFOutputStream((OutputStream)fos);
                IOUtils.copy((InputStream)in, (OutputStream)out, (int)buffer);
                FileUtils.closeQuietly((InputStream)in);
                FileUtils.closeQuietly((InputStream)fis);
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
                in = null;
                fis = null;
                out = null;
                fos = null;
                if (!removeInput || inputFile.delete()) break block5;
                result = "Failed to delete input file '" + inputFile + "' after successful compression!";
            }
            catch (Exception e) {
                try {
                    String msg = "Failed to compress '" + inputFile + "': ";
                    System.err.println(msg);
                    e.printStackTrace();
                    result = msg + e;
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(in);
                    FileUtils.closeQuietly(fis);
                    FileUtils.closeQuietly(out);
                    FileUtils.closeQuietly(fos);
                    throw throwable;
                }
                FileUtils.closeQuietly((InputStream)in);
                FileUtils.closeQuietly((InputStream)fis);
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
            }
        }
        FileUtils.closeQuietly((InputStream)in);
        FileUtils.closeQuietly((InputStream)fis);
        FileUtils.closeQuietly((OutputStream)out);
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }
}

