/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class RarUtils {
    public static List<File> decompress(File input, File outputDir) {
        return RarUtils.decompress(input, outputDir, false);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs) {
        return RarUtils.decompress(input, outputDir, createDirs, new BaseRegExp(""), false);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch) {
        return RarUtils.decompress(input, outputDir, createDirs, match, invertMatch, 1024);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch, int bufferSize) {
        return RarUtils.decompress(input, outputDir, createDirs, match, invertMatch, bufferSize, new StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch, int bufferSize, StringBuilder errors) {
        ArrayList<File> result = new ArrayList<File>();
        Archive archive = null;
        try {
            archive = new Archive(input.getAbsoluteFile());
            if (archive.isEncrypted()) {
                throw new IllegalStateException("Cannot handle encrypted archives!");
            }
            for (FileHeader entry : archive.getFileHeaders()) {
                String outName;
                FileOutputStream fos;
                BufferedOutputStream out;
                InputStream in;
                String error;
                String entryFilename;
                block21: {
                    File outFile;
                    entryFilename = entry.getFileNameString().replace("\\", "/");
                    if (entry.isEncrypted()) {
                        errors.append("Cannot handle encrypted file: " + entryFilename);
                        continue;
                    }
                    if (entry.isDirectory() && !createDirs || !match.isMatchAll() && !match.isEmpty() && (invertMatch && match.isMatch(entryFilename) || !invertMatch && !match.isMatch(entryFilename))) continue;
                    if (entry.isDirectory() && createDirs) {
                        outFile = new File(outputDir.getAbsolutePath() + File.separator + entryFilename);
                        if (outFile.exists() || outFile.mkdirs()) continue;
                        error = "Failed to create directory '" + outFile.getAbsolutePath() + "'!";
                        System.err.println(error);
                        errors.append(error + "\n");
                        continue;
                    }
                    in = null;
                    out = null;
                    fos = null;
                    outName = null;
                    outName = outputDir.getAbsolutePath() + File.separator;
                    outName = createDirs ? outName + entryFilename : outName + new File(entryFilename).getName();
                    outFile = new File(outName).getParentFile();
                    if (outFile.exists() || outFile.mkdirs()) break block21;
                    error = "Failed to create directory '" + outFile.getAbsolutePath() + "', skipping extraction of '" + outName + "'!";
                    System.err.println(error);
                    errors.append(error + "\n");
                    FileUtils.closeQuietly(in);
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    continue;
                }
                try {
                    fos = new FileOutputStream(outName);
                    out = new BufferedOutputStream(fos, bufferSize);
                    archive.extractFile(entry, (OutputStream)out);
                    result.add(new File(outName));
                }
                catch (Exception e) {
                    try {
                        error = "Error extracting '" + entryFilename + "' to '" + outName + "': " + e;
                        System.err.println(error);
                        errors.append(error + "\n");
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeQuietly(in);
                        FileUtils.closeQuietly(out);
                        FileUtils.closeQuietly(fos);
                        throw throwable;
                        return result;
                    }
                    FileUtils.closeQuietly(in);
                    FileUtils.closeQuietly(out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    continue;
                }
                FileUtils.closeQuietly(in);
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errors.append("Error occurred: " + e + "\n");
            return result;
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean decompress(File input, String archiveFile, File output) {
        return RarUtils.decompress(input, archiveFile, output, false);
    }

    public static boolean decompress(File input, String archiveFile, File output, boolean createDirs) {
        return RarUtils.decompress(input, archiveFile, output, createDirs, 1024, new StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean decompress(File input, String archiveFile, File output, boolean createDirs, int bufferSize, StringBuilder errors) {
        boolean result = false;
        Archive rarfile = null;
        try {
            rarfile = new Archive(input.getAbsoluteFile());
            for (FileHeader entry : rarfile.getFileHeaders()) {
                String error;
                String outName;
                FileOutputStream fos;
                BufferedOutputStream out;
                InputStream in;
                String entryFilename;
                block20: {
                    File outFile;
                    block21: {
                        entryFilename = entry.getFileNameString().replace("\\", "/");
                        if (entry.isDirectory() || !entryFilename.equals(archiveFile)) continue;
                        if (entry.isEncrypted()) {
                            errors.append("Cannot handle encrypted file: " + entryFilename);
                            continue;
                        }
                        in = null;
                        out = null;
                        fos = null;
                        outName = null;
                        outName = output.getAbsolutePath();
                        outFile = new File(outName).getParentFile();
                        if (outFile.exists()) break block20;
                        if (createDirs) break block21;
                        error = "Output directory '" + outFile.getAbsolutePath() + " does not exist', skipping extraction of '" + outName + "'!";
                        System.err.println(error);
                        errors.append(error + "\n");
                        FileUtils.closeQuietly(in);
                        FileUtils.closeQuietly((OutputStream)out);
                        FileUtils.closeQuietly((OutputStream)fos);
                        return result;
                    }
                    if (outFile.mkdirs()) break block20;
                    error = "Failed to create directory '" + outFile.getAbsolutePath() + "', skipping extraction of '" + outName + "'!";
                    System.err.println(error);
                    errors.append(error + "\n");
                    FileUtils.closeQuietly(in);
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    return result;
                }
                try {
                    fos = new FileOutputStream(outName);
                    out = new BufferedOutputStream(fos, bufferSize);
                    rarfile.extractFile(entry, (OutputStream)out);
                    result = true;
                }
                catch (Exception e) {
                    try {
                        result = false;
                        error = "Error extracting '" + entryFilename + "' to '" + outName + "': " + e;
                        System.err.println(error);
                        errors.append(error + "\n");
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeQuietly(in);
                        FileUtils.closeQuietly(out);
                        FileUtils.closeQuietly(fos);
                        throw throwable;
                        return result;
                    }
                    FileUtils.closeQuietly(in);
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    continue;
                }
                FileUtils.closeQuietly(in);
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
                return result;
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            errors.append("Error occurred: " + e + "\n");
            return result;
        }
        finally {
            if (rarfile != null) {
                try {
                    rarfile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static List<File> listFiles(File input) {
        return RarUtils.listFiles(input, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> listFiles(File input, boolean listDirs) {
        ArrayList<File> result = new ArrayList<File>();
        Archive rarfile = null;
        try {
            rarfile = new Archive(input.getAbsoluteFile());
            if (rarfile.isEncrypted()) {
                ArrayList<File> arrayList = result;
                return arrayList;
            }
            for (FileHeader entry : rarfile.getFileHeaders()) {
                String entryFilename = entry.getFileNameString().replace("\\", "/");
                if (entry.isEncrypted()) continue;
                if (entry.isDirectory()) {
                    if (!listDirs) continue;
                    result.add(new File(entryFilename));
                    continue;
                }
                result.add(new File(entryFilename));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rarfile != null) {
                try {
                    rarfile.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }
}

