/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.BufferSupporter;
import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public abstract class AbstractSingleDecompress
extends AbstractTransformer
implements BufferSupporter {
    private static final long serialVersionUID = -8337511248726861039L;
    public static final String DUMMY_EXTENSION = ".decompressed";
    protected boolean m_UseAlternativeOutputDir;
    protected PlaceholderDirectory m_AlternativeOutputDir;
    protected String m_AlternativeFilename;
    protected int m_BufferSize;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-out-dir", "useAlternativeOutputDir", (Object)false);
        this.m_OptionManager.add("out-dir", "alternativeOutputDir", (Object)new PlaceholderDirectory("."));
        this.m_OptionManager.add("alt-filename", "alternativeFilename", (Object)"");
        this.m_OptionManager.add("buffer", "bufferSize", (Object)1024);
    }

    protected abstract String getDefaultExtension();

    public void setUseAlternativeOutputDir(boolean value) {
        this.m_UseAlternativeOutputDir = value;
        this.reset();
    }

    public boolean getUseAlternativeOutputDir() {
        return this.m_UseAlternativeOutputDir;
    }

    public abstract String useAlternativeOutputDirTipText();

    public void setAlternativeOutputDir(PlaceholderDirectory value) {
        this.m_AlternativeOutputDir = value;
        this.reset();
    }

    public PlaceholderDirectory getAlternativeOutputDir() {
        return this.m_AlternativeOutputDir;
    }

    public String alternativeOutputDirTipText() {
        return "The alternative output directory to use.";
    }

    public void setAlternativeFilename(String value) {
        this.m_AlternativeFilename = value;
        this.reset();
    }

    public String getAlternativeFilename() {
        return this.m_AlternativeFilename;
    }

    public abstract String alternativeFilenameTipText();

    public void setBufferSize(int value) {
        if (this.getOptionManager().isValid("bufferSize", (Number)value)) {
            this.m_BufferSize = value;
            this.reset();
        }
    }

    public int getBufferSize() {
        return this.m_BufferSize;
    }

    public String bufferSizeTipText() {
        return "The size of the buffer in bytes for the data stream.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.hasVariable((OptionHandler)this, (String)"useAlternativeOutputDir") || this.m_UseAlternativeOutputDir ? QuickInfoHelper.toString((OptionHandler)this, (String)"alternativeOutputDir", (Object)this.m_AlternativeOutputDir) : "<from input>";
        String variable = QuickInfoHelper.getVariable((OptionHandler)this, (String)"alternativeFilename");
        if (variable != null) {
            result = result + File.separator + variable;
        } else if (this.m_AlternativeFilename != null && this.m_AlternativeFilename.length() > 0) {
            result = result + File.separator + this.m_AlternativeFilename;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected abstract String decompress(File var1, File var2);

    protected String doExecute() {
        File inFile = null;
        if (this.m_InputToken.getPayload() instanceof File) {
            inFile = (File)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof String) {
            inFile = new PlaceholderFile((String)this.m_InputToken.getPayload());
        }
        String output = this.m_UseAlternativeOutputDir ? this.m_AlternativeOutputDir.getAbsolutePath() : inFile.getParentFile().getAbsolutePath();
        output = output + File.separator;
        output = this.m_AlternativeFilename.length() > 0 ? output + this.m_AlternativeFilename : (inFile.getName().endsWith(this.getDefaultExtension()) ? output + inFile.getName().replaceAll("\\" + this.getDefaultExtension() + "$", "") : output + inFile.getName() + DUMMY_EXTENSION);
        File outFile = new File(output);
        String result = this.decompress(inFile, outFile);
        if (result == null) {
            this.m_OutputToken = new Token((Object)output);
        }
        return result;
    }
}

