/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class ZstdUtils {
    public static final String EXTENSION = ".zst";

    public static String decompress(File archiveFile, int buffer) {
        return ZstdUtils.decompress(archiveFile, buffer, (File)new PlaceholderFile(archiveFile.getAbsolutePath().replaceAll("\\.zst$", "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(File archiveFile, int buffer, File outputFile) {
        ZstdInputStream in = null;
        BufferedOutputStream out = null;
        FileInputStream fis = null;
        String result = null;
        try {
            int len;
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            byte[] buf = new byte[buffer];
            fis = new FileInputStream(archiveFile.getAbsolutePath());
            in = new ZstdInputStream((InputStream)new BufferedInputStream(fis));
            out = new BufferedOutputStream(new FileOutputStream(outputFile), buffer);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            try {
                String msg = "Failed to decompress '" + archiveFile + "': ";
                System.err.println(msg);
                e.printStackTrace();
                result = msg + e;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fis);
                FileUtils.closeQuietly(in);
                FileUtils.closeQuietly(out);
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)fis);
            FileUtils.closeQuietly((InputStream)in);
            FileUtils.closeQuietly((OutputStream)out);
        }
        FileUtils.closeQuietly((InputStream)fis);
        FileUtils.closeQuietly((InputStream)in);
        FileUtils.closeQuietly((OutputStream)out);
        return result;
    }

    public static String compress(File inputFile, int buffer) {
        return ZstdUtils.compress(inputFile, buffer, (File)new PlaceholderFile(inputFile.getAbsolutePath() + EXTENSION));
    }

    public static String compress(File inputFile, int buffer, File outputFile) {
        return ZstdUtils.compress(inputFile, buffer, outputFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compress(File inputFile, int buffer, File outputFile, boolean removeInput) {
        String result;
        FileOutputStream fos;
        ZstdOutputStream out;
        FileInputStream fis;
        BufferedInputStream in;
        block6: {
            in = null;
            fis = null;
            out = null;
            fos = null;
            result = null;
            try {
                int len;
                if (outputFile.exists()) {
                    System.err.println("WARNING: overwriting '" + outputFile + "'!");
                }
                byte[] buf = new byte[buffer];
                fos = new FileOutputStream(outputFile);
                out = new ZstdOutputStream((OutputStream)fos);
                fis = new FileInputStream(inputFile.getAbsolutePath());
                in = new BufferedInputStream(fis);
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                FileUtils.closeQuietly((InputStream)in);
                FileUtils.closeQuietly((InputStream)fis);
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
                in = null;
                fis = null;
                out = null;
                fos = null;
                if (!removeInput || inputFile.delete()) break block6;
                result = "Failed to delete input file '" + inputFile + "' after successful compression!";
            }
            catch (Exception e) {
                try {
                    String msg = "Failed to compress '" + inputFile + "': ";
                    System.err.println(msg);
                    e.printStackTrace();
                    result = msg + e;
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(in);
                    FileUtils.closeQuietly(fis);
                    FileUtils.closeQuietly(out);
                    FileUtils.closeQuietly(fos);
                    throw throwable;
                }
                FileUtils.closeQuietly((InputStream)in);
                FileUtils.closeQuietly((InputStream)fis);
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
            }
        }
        FileUtils.closeQuietly((InputStream)in);
        FileUtils.closeQuietly((InputStream)fis);
        FileUtils.closeQuietly((OutputStream)out);
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }
}

