/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.ZstdUtils;
import adams.flow.transformer.AbstractSingleDecompress;
import java.io.File;

public class UnZstd
extends AbstractSingleDecompress {
    private static final long serialVersionUID = -8357597085805205924L;

    public String globalInfo() {
        return "Decompresses an archive that was compressed with Zstd. It is assumed, that the file ends with .zst. If that is not the case, an alternative filename has to be provided.\nThe filename of the generated output filename is then broadcasted.";
    }

    @Override
    public String useAlternativeOutputDirTipText() {
        return "By default the compressed file will be uncompressed at the same location as the archive with the .zst extension; use this option to enabled the selection of a different output directory.";
    }

    @Override
    public String alternativeFilenameTipText() {
        return "The alternative filename to use, instead of the one from the input file with the .zst extension removed.";
    }

    @Override
    protected String getDefaultExtension() {
        return ".zst";
    }

    @Override
    protected String decompress(File inFile, File outFile) {
        return ZstdUtils.decompress(inFile, this.m_BufferSize, outFile);
    }
}

