/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.filecommander;

import adams.core.io.Bzip2Utils;
import adams.gui.core.GUIHelper;
import adams.gui.tools.filecommander.AbstractFileCommanderAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.SwingWorker;

public class Bzip2
extends AbstractFileCommanderAction {
    private static final long serialVersionUID = -8374323161691034031L;

    public Bzip2() {
        this.setName("Bzip2");
    }

    protected void doActionPerformed(ActionEvent e) {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                File file = Bzip2.this.getOwner().getActive().getFilePanel().getSelectedFile();
                String msg = Bzip2Utils.compress(file, 1024);
                if (msg != null) {
                    GUIHelper.showErrorMessage((Component)Bzip2.this.getOwner(), (String)("Failed to compress the following file using Bzip2:\n" + file + "\n" + msg));
                } else {
                    Bzip2.this.getOwner().getActive().reload();
                    Bzip2.this.showStatus("Compressed " + file + " using Bzip2");
                }
                return null;
            }
        };
        worker.execute();
    }

    public void update() {
        boolean local = this.getOwner().getActive().getFilePanel().isLocal();
        File[] files = this.getOwner().getActive().getFilePanel().getSelectedFiles();
        this.setEnabled(local && files.length == 1 && files[0].isFile() && !files[0].getName().endsWith(".bz2"));
    }
}

