/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.MessageCollection;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import com.github.junrar.Archive;
import com.github.junrar.UnrarCallback;
import com.github.junrar.Volume;
import com.github.junrar.rarfile.FileHeader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class RarUtils {
    protected static Logger LOGGER = LoggingHelper.getLogger(RarUtils.class);

    public static List<File> decompress(File input, File outputDir) {
        return RarUtils.decompress(input, outputDir, false);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs) {
        return RarUtils.decompress(input, outputDir, createDirs, new BaseRegExp(""), false);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch) {
        return RarUtils.decompress(input, outputDir, createDirs, match, invertMatch, 1024);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch, int bufferSize) {
        return RarUtils.decompress(input, outputDir, createDirs, match, invertMatch, bufferSize, new MessageCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch, int bufferSize, MessageCollection errors) {
        ArrayList<File> result = new ArrayList<File>();
        Archive archive = null;
        try {
            archive = new Archive(input.getAbsoluteFile(), (UnrarCallback)new DummyUnrarCallback());
            if (archive.isEncrypted()) {
                throw new IllegalStateException("Cannot handle encrypted archives!");
            }
            Iterator iterator = archive.getFileHeaders().iterator();
            while (iterator.hasNext()) {
                FileOutputStream fos;
                BufferedOutputStream out;
                InputStream in;
                block24: {
                    block23: {
                        String msg;
                        File outFile;
                        FileHeader entry = (FileHeader)iterator.next();
                        String entryFilename = entry.getFileNameString().replace("\\", "/");
                        if (entry.isEncrypted()) {
                            errors.add("Cannot handle encrypted file: " + entryFilename);
                            continue;
                        }
                        if (entry.isDirectory() && !createDirs || !match.isMatchAll() && !match.isEmpty() && (invertMatch && match.isMatch(entryFilename) || !invertMatch && !match.isMatch(entryFilename))) continue;
                        if (entry.isDirectory() && createDirs) {
                            outFile = new File(outputDir.getAbsolutePath() + File.separator + entryFilename);
                            if (outFile.exists() || outFile.mkdirs()) continue;
                            msg = "Failed to create directory '" + outFile.getAbsolutePath() + "'!";
                            LOGGER.log(Level.SEVERE, msg);
                            errors.add(msg);
                            continue;
                        }
                        in = null;
                        out = null;
                        fos = null;
                        String outName = null;
                        try {
                            outName = outputDir.getAbsolutePath() + File.separator;
                            outName = createDirs ? outName + entryFilename : outName + new File(entryFilename).getName();
                            outFile = new File(outName).getParentFile();
                            if (!outFile.exists() && !outFile.mkdirs()) {
                                msg = "Failed to create directory '" + outFile.getAbsolutePath() + "', skipping extraction of '" + outName + "'!";
                                LOGGER.log(Level.SEVERE, msg);
                                errors.add(msg);
                                FileUtils.closeQuietly(in);
                                break block23;
                            }
                            fos = new FileOutputStream(outName);
                            out = new BufferedOutputStream(fos, bufferSize);
                            archive.extractFile(entry, (OutputStream)out);
                            result.add(new File(outName));
                            FileUtils.closeQuietly(in);
                            break block24;
                        }
                        catch (Exception e) {
                            msg = "Error extracting '" + entryFilename + "' to '" + outName + "': ";
                            LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                            errors.add(msg, (Throwable)e);
                            continue;
                        }
                    }
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    continue;
                }
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
                continue;
                finally {
                    FileUtils.closeQuietly(in);
                    FileUtils.closeQuietly(out);
                    FileUtils.closeQuietly(fos);
                }
            }
            return result;
        }
        catch (Exception e) {
            String msg = "Error occurred: ";
            LOGGER.log(Level.SEVERE, msg, (Throwable)e);
            errors.add(msg, (Throwable)e);
            return result;
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean decompress(File input, String archiveFile, File output) {
        return RarUtils.decompress(input, archiveFile, output, false);
    }

    public static boolean decompress(File input, String archiveFile, File output, boolean createDirs) {
        return RarUtils.decompress(input, archiveFile, output, createDirs, 1024, new MessageCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean decompress(File input, String archiveFile, File output, boolean createDirs, int bufferSize, MessageCollection errors) {
        boolean result = false;
        Archive rarfile = null;
        try {
            rarfile = new Archive(input.getAbsoluteFile(), (UnrarCallback)new DummyUnrarCallback());
            for (FileHeader entry : rarfile.getFileHeaders()) {
                String msg;
                String outName;
                FileOutputStream fos;
                BufferedOutputStream out;
                InputStream in;
                String entryFilename;
                block20: {
                    File outFile;
                    block21: {
                        entryFilename = entry.getFileNameString().replace("\\", "/");
                        if (entry.isDirectory() || !entryFilename.equals(archiveFile)) continue;
                        if (entry.isEncrypted()) {
                            errors.add("Cannot handle encrypted file: " + entryFilename);
                            continue;
                        }
                        in = null;
                        out = null;
                        fos = null;
                        outName = null;
                        outName = output.getAbsolutePath();
                        outFile = new File(outName).getParentFile();
                        if (outFile.exists()) break block20;
                        if (createDirs) break block21;
                        msg = "Output directory '" + outFile.getAbsolutePath() + " does not exist', skipping extraction of '" + outName + "'!";
                        LOGGER.log(Level.SEVERE, msg);
                        errors.add(msg);
                        FileUtils.closeQuietly(in);
                        FileUtils.closeQuietly((OutputStream)out);
                        FileUtils.closeQuietly((OutputStream)fos);
                        return result;
                    }
                    if (outFile.mkdirs()) break block20;
                    msg = "Failed to create directory '" + outFile.getAbsolutePath() + "', skipping extraction of '" + outName + "'!";
                    LOGGER.log(Level.SEVERE, msg);
                    errors.add(msg);
                    FileUtils.closeQuietly(in);
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    return result;
                }
                try {
                    fos = new FileOutputStream(outName);
                    out = new BufferedOutputStream(fos, bufferSize);
                    rarfile.extractFile(entry, (OutputStream)out);
                    result = true;
                }
                catch (Exception e) {
                    try {
                        result = false;
                        msg = "Error extracting '" + entryFilename + "' to '" + outName + "': ";
                        LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                        errors.add(msg, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeQuietly(in);
                        FileUtils.closeQuietly(out);
                        FileUtils.closeQuietly(fos);
                        throw throwable;
                        return result;
                    }
                    FileUtils.closeQuietly(in);
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    continue;
                }
                FileUtils.closeQuietly(in);
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
                return result;
            }
        }
        catch (Exception e) {
            result = false;
            String msg = "Error occurred: ";
            LOGGER.log(Level.SEVERE, msg, (Throwable)e);
            errors.add(msg, (Throwable)e);
            return result;
        }
        finally {
            if (rarfile != null) {
                try {
                    rarfile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static List<File> listFiles(File input) {
        return RarUtils.listFiles(input, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> listFiles(File input, boolean listDirs) {
        ArrayList<File> result = new ArrayList<File>();
        Archive rarfile = null;
        try {
            rarfile = new Archive(input.getAbsoluteFile(), (UnrarCallback)new DummyUnrarCallback());
            if (rarfile.isEncrypted()) {
                ArrayList<File> arrayList = result;
                return arrayList;
            }
            for (FileHeader entry : rarfile.getFileHeaders()) {
                String entryFilename = entry.getFileNameString().replace("\\", "/");
                if (entry.isEncrypted()) continue;
                if (entry.isDirectory()) {
                    if (!listDirs) continue;
                    result.add(new File(entryFilename));
                    continue;
                }
                result.add(new File(entryFilename));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rarfile != null) {
                try {
                    rarfile.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public static class DummyUnrarCallback
    implements UnrarCallback {
        public boolean isNextVolumeReady(Volume nextVolume) {
            return false;
        }

        public void volumeProgressChanged(long current, long total) {
        }
    }
}

