/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.License;
import adams.core.MessageCollection;
import adams.core.annotation.MixedCopyright;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class TarUtils {
    protected static Logger LOGGER = LoggingHelper.getLogger(TarUtils.class);

    public static Compression determineCompression(File archive) {
        return TarUtils.determineCompression(archive.getAbsolutePath());
    }

    public static Compression determineCompression(String archive) {
        if ((archive = archive.toLowerCase()).endsWith(".tar.gz")) {
            return Compression.GZIP;
        }
        if (archive.endsWith(".tgz")) {
            return Compression.GZIP;
        }
        if (archive.endsWith(".tar.bz2")) {
            return Compression.BZIP2;
        }
        return Compression.NONE;
    }

    public static TarArchiveInputStream openArchiveForReading(File file, FileInputStream stream) throws Exception {
        Compression comp = TarUtils.determineCompression(file);
        if (comp == Compression.GZIP) {
            return new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(stream)));
        }
        if (comp == Compression.BZIP2) {
            return new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream((InputStream)new BufferedInputStream(stream)));
        }
        return new TarArchiveInputStream((InputStream)new BufferedInputStream(stream));
    }

    public static TarArchiveOutputStream openArchiveForWriting(File input, FileOutputStream stream) throws Exception {
        Compression comp = TarUtils.determineCompression(input);
        TarArchiveOutputStream result = comp == Compression.GZIP ? new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(stream))) : (comp == Compression.BZIP2 ? new TarArchiveOutputStream((OutputStream)new BZip2CompressorOutputStream((OutputStream)new BufferedOutputStream(stream))) : new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(stream)));
        result.setLongFileMode(2);
        return result;
    }

    public static String compress(File output, File[] files) {
        return TarUtils.compress(output, files, 1024);
    }

    public static String compress(File output, File[] files, int bufferSize) {
        return TarUtils.compress(output, files, "", bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(author="Jeremy Whitlock (jcscoobyrs)", copyright="2010 Jeremy Whitlock", license=License.APACHE2, url="http://www.thoughtspark.org/node/53")
    public static String compress(File output, File[] files, String stripRegExp, int bufferSize) {
        BufferedInputStream in = null;
        FileInputStream fis = null;
        TarArchiveOutputStream out = null;
        FileOutputStream fos = null;
        String result = null;
        try {
            if (output.exists()) {
                LOGGER.warning("overwriting '" + output + "'!");
            }
            byte[] buf = new byte[bufferSize];
            fos = new FileOutputStream(output.getAbsolutePath());
            out = TarUtils.openArchiveForWriting(output, fos);
            for (int i = 0; i < files.length; ++i) {
                int len;
                fis = new FileInputStream(files[i].getAbsolutePath());
                in = new BufferedInputStream(fis);
                String filename = files[i].getParentFile().getAbsolutePath();
                if (stripRegExp.length() > 0) {
                    filename = filename.replaceFirst(stripRegExp, "");
                }
                if (filename.length() > 0) {
                    filename = filename + File.separator;
                }
                filename = filename + files[i].getName();
                TarArchiveEntry entry = new TarArchiveEntry(filename);
                if (files[i].isFile()) {
                    entry.setSize(files[i].length());
                }
                out.putArchiveEntry((ArchiveEntry)entry);
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeArchiveEntry();
                FileUtils.closeQuietly((InputStream)in);
                FileUtils.closeQuietly((InputStream)fis);
                in = null;
                fis = null;
            }
            FileUtils.closeQuietly((OutputStream)out);
            FileUtils.closeQuietly((OutputStream)fos);
            out = null;
            fos = null;
        }
        catch (Exception e) {
            try {
                String msg = "Failed to generate archive '" + output + "': ";
                LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                result = msg + e;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(in);
                FileUtils.closeQuietly(fis);
                FileUtils.closeQuietly(out);
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
            FileUtils.closeQuietly(in);
            FileUtils.closeQuietly((InputStream)fis);
            FileUtils.closeQuietly((OutputStream)out);
            FileUtils.closeQuietly((OutputStream)fos);
        }
        FileUtils.closeQuietly(in);
        FileUtils.closeQuietly((InputStream)fis);
        FileUtils.closeQuietly((OutputStream)out);
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }

    public static List<File> decompress(File input, File outputDir) {
        return TarUtils.decompress(input, outputDir, false);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs) {
        return TarUtils.decompress(input, outputDir, createDirs, new BaseRegExp(""), false);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch) {
        return TarUtils.decompress(input, outputDir, createDirs, match, invertMatch, 1024);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch, int bufferSize) {
        return TarUtils.decompress(input, outputDir, createDirs, match, invertMatch, bufferSize, new MessageCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch, int bufferSize, MessageCollection errors) {
        TarArchiveEntry entry;
        ArrayList<File> result = new ArrayList<File>();
        TarArchiveInputStream archive = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        byte[] buffer = new byte[bufferSize];
        fis = new FileInputStream(input.getAbsoluteFile());
        archive = TarUtils.openArchiveForReading(input, fis);
        while ((entry = archive.getNextTarEntry()) != null) {
            String msg;
            File outFile;
            if (entry.isDirectory() && !createDirs || !match.isMatchAll() && !match.isEmpty() && (invertMatch && match.isMatch(entry.getName()) || !invertMatch && !match.isMatch(entry.getName()))) continue;
            if (entry.isDirectory() && createDirs) {
                outFile = new File(outputDir.getAbsolutePath() + File.separator + entry.getName());
                if (outFile.mkdirs()) continue;
                msg = "Failed to create directory '" + outFile.getAbsolutePath() + "'!";
                LOGGER.log(Level.SEVERE, msg);
                errors.add(msg);
                continue;
            }
            BufferedOutputStream out = null;
            String outName = null;
            try {
                int len;
                outName = outputDir.getAbsolutePath() + File.separator;
                outName = createDirs ? outName + entry.getName() : outName + new File(entry.getName()).getName();
                outFile = new File(outName).getParentFile();
                if (!outFile.exists() && !outFile.mkdirs()) {
                    msg = "Failed to create directory '" + outFile.getAbsolutePath() + "', skipping extraction of '" + outName + "'!";
                    LOGGER.log(Level.SEVERE, msg);
                    errors.add(msg);
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    continue;
                }
                fos = new FileOutputStream(outName);
                out = new BufferedOutputStream(fos, bufferSize);
                long size = entry.getSize();
                for (long read = 0L; read < size; read += (long)len) {
                    len = archive.read(buffer);
                    out.write(buffer, 0, len);
                }
                result.add(new File(outName));
                FileUtils.closeQuietly((OutputStream)out);
            }
            catch (Exception e) {
                msg = "Error extracting '" + entry.getName() + "' to '" + outName + "': ";
                LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                errors.add(msg, (Throwable)e);
                continue;
            }
            finally {
                FileUtils.closeQuietly(out);
                FileUtils.closeQuietly(fos);
                continue;
            }
            FileUtils.closeQuietly((OutputStream)fos);
        }
        FileUtils.closeQuietly((InputStream)fis);
        if (archive == null) return result;
        try {
            archive.close();
            return result;
        }
        catch (Exception e) {
            return result;
        }
        catch (Exception e) {
            try {
                String msg = "Error occurred: ";
                LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                errors.add(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fis);
                if (archive == null) throw throwable;
                try {
                    archive.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)fis);
            if (archive == null) return result;
            try {
                archive.close();
                return result;
            }
            catch (Exception exception) {
                return result;
            }
        }
    }

    public static boolean decompress(File input, String archiveFile, File output) {
        return TarUtils.decompress(input, archiveFile, output, false);
    }

    public static boolean decompress(File input, String archiveFile, File output, boolean createDirs) {
        return TarUtils.decompress(input, archiveFile, output, createDirs, 1024, new MessageCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean decompress(File input, String archiveFile, File output, boolean createDirs, int bufferSize, MessageCollection errors) {
        result = false;
        archive = null;
        fis = null;
        fos = null;
        try {
            buffer = new byte[bufferSize];
            fis = new FileInputStream(input.getAbsoluteFile());
            archive = TarUtils.openArchiveForReading(input, fis);
            while ((entry = archive.getNextTarEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().equals(archiveFile)) continue;
                out = null;
                outName = null;
                try {
                    outName = output.getAbsolutePath();
                    outFile = new File(outName).getParentFile();
                    if (outFile.exists()) ** GOTO lbl-1000
                    if (createDirs) ** GOTO lbl-1000
                    msg = "Output directory '" + outFile.getAbsolutePath() + " does not exist', skipping extraction of '" + outName + "'!";
                    TarUtils.LOGGER.log(Level.SEVERE, msg);
                    errors.add(msg);
                    ** GOTO lbl33
                }
                catch (Exception e) {
                    try {
                        result = false;
                        msg = "Error extracting '" + entry.getName() + "' to '" + outName + "': ";
                        TarUtils.LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                        errors.add(msg, (Throwable)e);
                    }
                    catch (Throwable var22_24) {
                        FileUtils.closeQuietly(out);
                        FileUtils.closeQuietly(fos);
                        throw var22_24;
                    }
lbl33:
                    // 1 sources

                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    ** GOTO lbl74
lbl-1000:
                    // 1 sources

                    {
                        if (outFile.mkdirs()) ** GOTO lbl-1000
                        msg = "Failed to create directory '" + outFile.getAbsolutePath() + "', skipping extraction of '" + outName + "'!";
                        TarUtils.LOGGER.log(Level.SEVERE, msg);
                        errors.add(msg);
                    }
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    ** GOTO lbl74
lbl-1000:
                    // 2 sources

                    {
                        fos = new FileOutputStream(outName);
                        out = new BufferedOutputStream(fos, bufferSize);
                        size = entry.getSize();
                        for (read = 0L; read < size; read += (long)len) {
                            len = archive.read(buffer);
                            out.write(buffer, 0, len);
                        }
                        result = true;
                    }
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    ** GOTO lbl74
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                }
            }
            ** GOTO lbl74
        }
        catch (Exception e) {
            try {
                result = false;
                msg = "Error occurred: ";
                TarUtils.LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                errors.add(msg, (Throwable)e);
            }
            catch (Throwable var23_25) {
                FileUtils.closeQuietly(fis);
                if (archive == null) throw var23_25;
                try {
                    archive.close();
                    throw var23_25;
                }
                catch (Exception var24_26) {
                    // empty catch block
                }
                throw var23_25;
            }
lbl74:
            // 4 sources

            FileUtils.closeQuietly((InputStream)fis);
            if (archive == null) return result;
            try {
                archive.close();
                return result;
            }
            catch (Exception e) {
                return result;
            }
            FileUtils.closeQuietly((InputStream)fis);
            if (archive == null) return result;
            try {
                archive.close();
                return result;
            }
            catch (Exception var21_20) {
                return result;
            }
        }
    }

    public static List<File> listFiles(File input) {
        return TarUtils.listFiles(input, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> listFiles(File input, boolean listDirs) {
        ArrayList<File> result = new ArrayList<File>();
        TarArchiveInputStream archive = null;
        FileInputStream fis = null;
        try {
            TarArchiveEntry entry;
            fis = new FileInputStream(input.getAbsolutePath());
            archive = TarUtils.openArchiveForReading(input, fis);
            while ((entry = archive.getNextTarEntry()) != null) {
                if (entry.isDirectory()) {
                    if (!listDirs) continue;
                    result.add(new File(entry.getName()));
                    continue;
                }
                result.add(new File(entry.getName()));
            }
        }
        catch (Exception e) {
            try {
                LOGGER.log(Level.SEVERE, "Error occurred: ", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fis);
                if (archive != null) {
                    try {
                        archive.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)fis);
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (Exception exception) {}
            }
        }
        FileUtils.closeQuietly((InputStream)fis);
        if (archive != null) {
            try {
                archive.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static enum Compression {
        AUTO,
        NONE,
        GZIP,
        BZIP2;

    }
}

