/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.filesearch;

import adams.core.exception.ExceptionHandler;
import adams.core.io.FileUtils;
import adams.core.io.filesearch.AbstractMetaFileSearchHandlerWithEncoding;
import com.ning.compress.lzf.LZFInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class LzfFileSearchHandler
extends AbstractMetaFileSearchHandlerWithEncoding {
    private static final long serialVersionUID = 2030528214619565963L;

    public String globalInfo() {
        return "Searches lzf-compressed (text) files.";
    }

    public boolean handles(String file) {
        return file.toLowerCase().endsWith(".lzf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchFile(String file, String searchText, boolean caseSensitive, ExceptionHandler handler) {
        boolean result;
        block6: {
            result = false;
            FileInputStream fis = null;
            LZFInputStream cis = null;
            InputStreamReader isr = null;
            this.m_Stopped = false;
            try {
                fis = new FileInputStream(file);
                cis = new LZFInputStream((InputStream)fis);
                isr = new InputStreamReader((InputStream)cis, this.m_Encoding.charsetValue());
                result = this.m_Handler.searchStream((Reader)isr, searchText, caseSensitive, handler);
                FileUtils.closeQuietly((Reader)isr);
            }
            catch (Exception e) {
                if (handler != null) {
                    handler.handleException("Failed to search: " + file, (Throwable)e);
                }
                break block6;
            }
            finally {
                FileUtils.closeQuietly(isr);
                FileUtils.closeQuietly(cis);
                FileUtils.closeQuietly((InputStream)fis);
            }
            FileUtils.closeQuietly((InputStream)cis);
            FileUtils.closeQuietly((InputStream)fis);
        }
        return result;
    }
}

