/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.filesearch;

import adams.core.exception.ExceptionHandler;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.RarUtils;
import adams.core.io.filesearch.AbstractMetaFileSearchHandlerWithEncoding;
import com.github.junrar.Archive;
import com.github.junrar.UnrarCallback;
import com.github.junrar.rarfile.FileHeader;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class RarFileSearchHandler
extends AbstractMetaFileSearchHandlerWithEncoding {
    private static final long serialVersionUID = 2030528214619565963L;

    public String globalInfo() {
        return "Searches rar-compressed (text) files.";
    }

    public boolean handles(String file) {
        return file.toLowerCase().endsWith(".rar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean searchFile(String file, String searchText, boolean caseSensitive, ExceptionHandler handler) {
        boolean result = false;
        Archive archive = null;
        this.m_Stopped = false;
        try {
            archive = new Archive(new PlaceholderFile(file).getAbsoluteFile(), (UnrarCallback)new RarUtils.DummyUnrarCallback());
            if (archive.isEncrypted()) {
                throw new IllegalStateException("Cannot handle encrypted archives!");
            }
            for (FileHeader entry : archive.getFileHeaders()) {
                if (this.m_Stopped) {
                    return result;
                }
                if (entry.isDirectory()) continue;
                BufferedInputStream in = null;
                InputStreamReader isr = null;
                try {
                    in = new BufferedInputStream(archive.getInputStream(entry));
                    isr = new InputStreamReader((InputStream)in, this.m_Encoding.charsetValue());
                    result = this.m_Handler.searchStream((Reader)isr, searchText, caseSensitive, handler);
                }
                catch (Exception e) {
                    block19: {
                        try {
                            if (handler == null) break block19;
                            handler.handleException("Failed to zip/entry: " + file + "/" + entry.getFileNameString(), (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            FileUtils.closeQuietly(isr);
                            FileUtils.closeQuietly(in);
                            throw throwable;
                            return result;
                        }
                    }
                    FileUtils.closeQuietly(isr);
                    FileUtils.closeQuietly((InputStream)in);
                    continue;
                }
                FileUtils.closeQuietly((Reader)isr);
                FileUtils.closeQuietly((InputStream)in);
            }
        }
        catch (Exception e) {
            if (handler == null) return result;
            handler.handleException("Failed to search: " + file, (Throwable)e);
            return result;
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

