/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.io.GzipUtils;
import adams.flow.transformer.AbstractSingleDecompress;
import gnu.trove.list.TByteList;
import java.io.File;

public class GUNZIP
extends AbstractSingleDecompress {
    private static final long serialVersionUID = 1162255296803420631L;

    public String globalInfo() {
        return "Decompresses an archive that was compressed with gzip. It is assumed, that the file ends with .gz. If that is not the case, an alternative filename has to be provided.\nThe filename of the generated output filename is then broadcasted.";
    }

    @Override
    public String useAlternativeOutputDirTipText() {
        return "By default the compressed file will be uncompressed at the same location as the archive with the .gz extension; use this option to enabled the selection of a different output directory.";
    }

    @Override
    public String alternativeFilenameTipText() {
        return "The alternative filename to use, instead of the one from the input file with the .gz extension removed.";
    }

    @Override
    protected String getDefaultExtension() {
        return ".gz";
    }

    @Override
    protected String decompress(File inFile, File outFile) {
        return GzipUtils.decompress((File)inFile, (int)this.m_BufferSize, (File)outFile);
    }

    @Override
    protected String decompress(byte[] inBytes, TByteList outBytes) {
        MessageCollection errors = new MessageCollection();
        byte[] decompressed = GzipUtils.decompress((byte[])inBytes, (int)this.m_BufferSize, (MessageCollection)errors);
        if (decompressed == null) {
            return errors.isEmpty() ? "Failed to compress!" : errors.toString();
        }
        outBytes.addAll(decompressed);
        return null;
    }
}

