/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.io.LzfUtils;
import adams.flow.transformer.AbstractSingleDecompress;
import gnu.trove.list.TByteList;
import java.io.File;

public class UnLzf
extends AbstractSingleDecompress {
    private static final long serialVersionUID = -5393442425429782028L;

    public String globalInfo() {
        return "Decompresses an archive that was compressed with LZF. It is assumed, that the file ends with .lzf. If that is not the case, an alternative filename has to be provided.\nThe filename of the generated output filename is then broadcasted.\n\nMore information see here:\nhttp://en.wikibooks.org/wiki/Data_Compression/Dictionary_compression#LZF";
    }

    @Override
    public String useAlternativeOutputDirTipText() {
        return "By default the compressed file will be uncompressed at the same location as the archive with the .lzf extension; use this option to enabled the selection of a different output directory.";
    }

    @Override
    public String alternativeFilenameTipText() {
        return "The alternative filename to use, instead of the one from the input file with the .lzf extension removed.";
    }

    @Override
    protected String getDefaultExtension() {
        return ".lzf";
    }

    @Override
    protected String decompress(File inFile, File outFile) {
        return LzfUtils.decompress(inFile, this.m_BufferSize, outFile);
    }

    @Override
    protected String decompress(byte[] inBytes, TByteList outBytes) {
        MessageCollection errors = new MessageCollection();
        byte[] decompressed = LzfUtils.decompress(inBytes, this.m_BufferSize, errors);
        if (decompressed == null) {
            return errors.isEmpty() ? "Failed to compress!" : errors.toString();
        }
        outBytes.addAll(decompressed);
        return null;
    }
}

