/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.io.XzUtils;
import adams.flow.transformer.AbstractSingleDecompress;
import gnu.trove.list.TByteList;
import java.io.File;

public class UnXz
extends AbstractSingleDecompress {
    private static final long serialVersionUID = -8357597085805205924L;

    public String globalInfo() {
        return "Decompresses an archive that was compressed with XZ. It is assumed, that the file ends with .xz. If that is not the case, an alternative filename has to be provided.\nThe filename of the generated output filename is then broadcasted.";
    }

    @Override
    public String useAlternativeOutputDirTipText() {
        return "By default the compressed file will be uncompressed at the same location as the archive with the .xz extension; use this option to enabled the selection of a different output directory.";
    }

    @Override
    public String alternativeFilenameTipText() {
        return "The alternative filename to use, instead of the one from the input file with the .xz extension removed.";
    }

    @Override
    protected String getDefaultExtension() {
        return ".xz";
    }

    @Override
    protected String decompress(File inFile, File outFile) {
        return XzUtils.decompress(inFile, this.m_BufferSize, outFile);
    }

    @Override
    protected String decompress(byte[] inBytes, TByteList outBytes) {
        MessageCollection errors = new MessageCollection();
        byte[] decompressed = XzUtils.decompress(inBytes, this.m_BufferSize, errors);
        if (decompressed == null) {
            return errors.isEmpty() ? "Failed to compress!" : errors.toString();
        }
        outBytes.addAll(decompressed);
        return null;
    }
}

