/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.filecommander;

import adams.core.io.ZstdUtils;
import adams.gui.core.GUIHelper;
import adams.gui.tools.filecommander.AbstractFileCommanderAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.SwingWorker;

public class Zstd
extends AbstractFileCommanderAction {
    private static final long serialVersionUID = -8374323161691034031L;

    public Zstd() {
        this.setName("Zstd");
    }

    protected void doActionPerformed(ActionEvent e) {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                File file = Zstd.this.getOwner().getActive().getFilePanel().getSelectedFile();
                String msg = ZstdUtils.compress(file, 1024);
                if (msg != null) {
                    GUIHelper.showErrorMessage((Component)Zstd.this.getOwner(), (String)("Failed to compress the following file using Zstd:\n" + file + "\n" + msg));
                } else {
                    Zstd.this.getOwner().getActive().reload();
                    Zstd.this.showStatus("Compressed " + file + " using Zstd");
                }
                return null;
            }
        };
        worker.execute();
    }

    public void update() {
        boolean local = this.getOwner().getActive().getFilePanel().isLocal();
        File[] files = this.getOwner().getActive().getFilePanel().getSelectedFiles();
        this.setEnabled(local && files.length == 1 && files[0].isFile() && !files[0].getName().endsWith(".xz"));
    }
}

