/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.Trigger;
import adams.flow.core.Actor;
import adams.flow.sink.DumpFile;
import adams.flow.source.DirectoryLister;
import adams.flow.source.StringConstants;
import adams.flow.transformer.ArrayToSequence;
import adams.flow.transformer.DeleteFile;
import adams.flow.transformer.SequenceToArray;
import adams.flow.transformer.Tar;
import adams.flow.transformer.TextFileReader;
import adams.flow.transformer.UnTar;
import adams.test.TmpDirectory;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class UnTarTest
extends AbstractFlowTest {
    public UnTarTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("external_source.flow");
        this.m_TestHelper.copyResourceToTmp("external_standalone.flow");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.tar");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.flow");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("external_source.flow");
        this.m_TestHelper.deleteFileFromTmp("external_standalone.flow");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.tar");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.flow");
        super.tearDown();
    }

    public Actor getActor() {
        StringConstants dummy = new StringConstants();
        dummy.setStrings(new BaseString[]{new BaseString("dummy")});
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("${TMP}/external_standalone.flow"), new BaseString("${TMP}/external_source.flow")});
        SequenceToArray s2a = new SequenceToArray();
        s2a.setArrayLength(2);
        Tar zip = new Tar();
        zip.setOutput((PlaceholderFile)new TmpFile("dumpfile.tar"));
        Trigger tr1 = new Trigger();
        tr1.setActors(new Actor[]{sc, s2a, zip});
        DirectoryLister dirDel = new DirectoryLister();
        dirDel.setWatchDir((PlaceholderDirectory)new TmpDirectory());
        dirDel.setListFiles(true);
        dirDel.setRegExp(new BaseRegExp("external_(standalone|source)\\.flow"));
        DeleteFile del = new DeleteFile();
        Trigger tr2 = new Trigger();
        tr2.setActors(new Actor[]{dirDel, del});
        DirectoryLister dirUn = new DirectoryLister();
        dirUn.setWatchDir((PlaceholderDirectory)new TmpDirectory());
        dirUn.setListFiles(true);
        dirUn.setRegExp(new BaseRegExp("dumpfile\\.tar"));
        UnTar untar = new UnTar();
        untar.setOutputDir((PlaceholderDirectory)new TmpDirectory());
        ArrayToSequence a2sUn2 = new ArrayToSequence();
        TextFileReader tfr = new TextFileReader();
        ArrayToSequence a2sUn3 = new ArrayToSequence();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.flow"));
        Trigger tr3 = new Trigger();
        tr3.setActors(new Actor[]{dirUn, untar, a2sUn2, tfr, a2sUn3, df});
        Flow flow = new Flow();
        flow.setActors(new Actor[]{dummy, tr1, tr2, tr3});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.flow"));
    }

    public static Test suite() {
        return new TestSuite(UnTarTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        UnTarTest.runTest((Test)UnTarTest.suite());
    }
}

