/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.License;
import adams.core.MessageCollection;
import adams.core.annotation.MixedCopyright;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import lzma.sdk.lzma.Decoder;
import lzma.streams.LzmaInputStream;
import lzma.streams.LzmaOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class LzmaUtils {
    public static final String EXTENSION = ".7z";
    protected static Logger LOGGER = LoggingHelper.getLogger(LzmaUtils.class);

    public static String decompress(File archiveFile, int buffer) {
        return LzmaUtils.decompress(archiveFile, buffer, (File)new PlaceholderFile(archiveFile.getAbsolutePath().replaceAll("\\.7z$", "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(copyright="Julien Ponge", license=License.APACHE2, url="https://github.com/jponge/lzma-java/blob/master/README.md")
    public static String decompress(File archiveFile, int buffer, File outputFile) {
        LzmaInputStream in = null;
        FileInputStream fis = null;
        BufferedOutputStream out = null;
        FileOutputStream fos = null;
        String result = null;
        try {
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            fis = new FileInputStream(archiveFile.getAbsolutePath());
            in = new LzmaInputStream((InputStream)new BufferedInputStream(fis), new Decoder());
            fos = new FileOutputStream(outputFile.getAbsolutePath());
            out = new BufferedOutputStream(fos);
            IOUtils.copy((InputStream)in, (OutputStream)out, (int)buffer);
        }
        catch (Exception e) {
            try {
                String msg = "Failed to decompress '" + archiveFile + "': ";
                LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                result = msg + e;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(in);
                FileUtils.closeQuietly(fis);
                FileUtils.closeQuietly(out);
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)in);
            FileUtils.closeQuietly((InputStream)fis);
            FileUtils.closeQuietly((OutputStream)out);
            FileUtils.closeQuietly((OutputStream)fos);
        }
        FileUtils.closeQuietly((InputStream)in);
        FileUtils.closeQuietly((InputStream)fis);
        FileUtils.closeQuietly((OutputStream)out);
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }

    public static String compress(File inputFile, int buffer) {
        return LzmaUtils.compress(inputFile, buffer, (File)new PlaceholderFile(inputFile.getAbsolutePath() + EXTENSION));
    }

    public static String compress(File inputFile, int buffer, File outputFile) {
        return LzmaUtils.compress(inputFile, buffer, outputFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(copyright="Julien Ponge", license=License.APACHE2, url="https://github.com/jponge/lzma-java/blob/master/README.md")
    public static String compress(File inputFile, int buffer, File outputFile, boolean removeInput) {
        String result;
        FileOutputStream fos;
        LzmaOutputStream out;
        FileInputStream fis;
        BufferedInputStream in;
        block5: {
            in = null;
            fis = null;
            out = null;
            fos = null;
            result = null;
            try {
                if (outputFile.exists()) {
                    System.err.println("WARNING: overwriting '" + outputFile + "'!");
                }
                fis = new FileInputStream(inputFile.getAbsolutePath());
                in = new BufferedInputStream(fis);
                fos = new FileOutputStream(outputFile.getAbsolutePath());
                out = new LzmaOutputStream.Builder((OutputStream)new BufferedOutputStream(fos)).build();
                IOUtils.copy((InputStream)in, (OutputStream)out, (int)buffer);
                FileUtils.closeQuietly((InputStream)in);
                FileUtils.closeQuietly((InputStream)fis);
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
                in = null;
                fis = null;
                out = null;
                fos = null;
                if (!removeInput || inputFile.delete()) break block5;
                result = "Failed to delete input file '" + inputFile + "' after successful compression!";
            }
            catch (Exception e) {
                try {
                    String msg = "Failed to compress '" + inputFile + "': ";
                    LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                    result = msg + e;
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(in);
                    FileUtils.closeQuietly(fis);
                    FileUtils.closeQuietly(out);
                    FileUtils.closeQuietly(fos);
                    throw throwable;
                }
                FileUtils.closeQuietly((InputStream)in);
                FileUtils.closeQuietly((InputStream)fis);
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
            }
        }
        FileUtils.closeQuietly((InputStream)in);
        FileUtils.closeQuietly((InputStream)fis);
        FileUtils.closeQuietly((OutputStream)out);
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }

    public static byte[] compress(byte[] input) {
        return LzmaUtils.compress(input, new MessageCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] input, MessageCollection errors) {
        byte[] byArray;
        ByteArrayInputStream bis = null;
        ByteArrayOutputStream bos = null;
        LzmaOutputStream cos = null;
        try {
            bis = new ByteArrayInputStream(input);
            bos = new ByteArrayOutputStream();
            cos = new LzmaOutputStream.Builder((OutputStream)bos).build();
            IOUtils.copy((InputStream)bis, (OutputStream)cos);
            FileUtils.closeQuietly((OutputStream)cos);
            byArray = bos.toByteArray();
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                String msg = "Failed to compress bytes!";
                LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                errors.add(msg, (Throwable)e);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(cos);
                FileUtils.closeQuietly(bos);
                FileUtils.closeQuietly((InputStream)bis);
                throw throwable;
            }
            FileUtils.closeQuietly((OutputStream)cos);
            FileUtils.closeQuietly((OutputStream)bos);
            FileUtils.closeQuietly((InputStream)bis);
            return byArray2;
        }
        FileUtils.closeQuietly((OutputStream)cos);
        FileUtils.closeQuietly((OutputStream)bos);
        FileUtils.closeQuietly((InputStream)bis);
        return byArray;
    }

    public static byte[] decompress(byte[] input, int buffer) {
        return LzmaUtils.decompress(input, buffer, new MessageCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] input, int buffer, MessageCollection errors) {
        byte[] byArray;
        LzmaInputStream cis = null;
        ByteArrayOutputStream bos = null;
        try {
            cis = new LzmaInputStream((InputStream)new ByteArrayInputStream(input), new Decoder());
            bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)cis, (OutputStream)bos, (int)buffer);
            byArray = bos.toByteArray();
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                String msg = "Failed to decompress bytes!";
                LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                errors.add(msg, (Throwable)e);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(cis);
                FileUtils.closeQuietly(bos);
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)cis);
            FileUtils.closeQuietly((OutputStream)bos);
            return byArray2;
        }
        FileUtils.closeQuietly((InputStream)cis);
        FileUtils.closeQuietly((OutputStream)bos);
        return byArray;
    }
}

