/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.MessageCollection;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.apache.commons.compress.utils.IOUtils;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;

public class XzUtils {
    public static final String EXTENSION = ".xz";
    protected static Logger LOGGER = LoggingHelper.getLogger(XzUtils.class);

    public static String decompress(File archiveFile, int buffer) {
        return XzUtils.decompress(archiveFile, buffer, (File)new PlaceholderFile(archiveFile.getAbsolutePath().replaceAll("\\.xz$", "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(File archiveFile, int buffer, File outputFile) {
        XZInputStream in = null;
        BufferedOutputStream out = null;
        FileInputStream fis = null;
        String result = null;
        try {
            int len;
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            byte[] buf = new byte[buffer];
            fis = new FileInputStream(archiveFile.getAbsolutePath());
            in = new XZInputStream((InputStream)new BufferedInputStream(fis));
            out = new BufferedOutputStream(new FileOutputStream(outputFile), buffer);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            try {
                String msg = "Failed to decompress '" + archiveFile + "': ";
                LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                result = msg + e;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fis);
                FileUtils.closeQuietly(in);
                FileUtils.closeQuietly(out);
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)fis);
            FileUtils.closeQuietly((InputStream)in);
            FileUtils.closeQuietly((OutputStream)out);
        }
        FileUtils.closeQuietly((InputStream)fis);
        FileUtils.closeQuietly((InputStream)in);
        FileUtils.closeQuietly((OutputStream)out);
        return result;
    }

    public static String compress(File inputFile, int buffer) {
        return XzUtils.compress(inputFile, buffer, (File)new PlaceholderFile(inputFile.getAbsolutePath() + EXTENSION));
    }

    public static String compress(File inputFile, int buffer, File outputFile) {
        return XzUtils.compress(inputFile, buffer, outputFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compress(File inputFile, int buffer, File outputFile, boolean removeInput) {
        String result;
        FileOutputStream fos;
        XZOutputStream out;
        FileInputStream fis;
        BufferedInputStream in;
        block6: {
            in = null;
            fis = null;
            out = null;
            fos = null;
            result = null;
            try {
                int len;
                if (outputFile.exists()) {
                    System.err.println("WARNING: overwriting '" + outputFile + "'!");
                }
                byte[] buf = new byte[buffer];
                fos = new FileOutputStream(outputFile);
                out = new XZOutputStream((OutputStream)fos, (FilterOptions)new LZMA2Options());
                fis = new FileInputStream(inputFile.getAbsolutePath());
                in = new BufferedInputStream(fis);
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                FileUtils.closeQuietly((InputStream)in);
                FileUtils.closeQuietly((InputStream)fis);
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
                in = null;
                fis = null;
                out = null;
                fos = null;
                if (!removeInput || inputFile.delete()) break block6;
                result = "Failed to delete input file '" + inputFile + "' after successful compression!";
            }
            catch (Exception e) {
                try {
                    String msg = "Failed to compress '" + inputFile + "': ";
                    LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                    result = msg + e;
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(in);
                    FileUtils.closeQuietly(fis);
                    FileUtils.closeQuietly(out);
                    FileUtils.closeQuietly(fos);
                    throw throwable;
                }
                FileUtils.closeQuietly((InputStream)in);
                FileUtils.closeQuietly((InputStream)fis);
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
            }
        }
        FileUtils.closeQuietly((InputStream)in);
        FileUtils.closeQuietly((InputStream)fis);
        FileUtils.closeQuietly((OutputStream)out);
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }

    public static byte[] compress(byte[] input) {
        return XzUtils.compress(input, new MessageCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] input, MessageCollection errors) {
        byte[] byArray;
        ByteArrayInputStream bis = null;
        ByteArrayOutputStream bos = null;
        XZOutputStream cos = null;
        try {
            bis = new ByteArrayInputStream(input);
            bos = new ByteArrayOutputStream();
            cos = new XZOutputStream((OutputStream)bos, (FilterOptions)new LZMA2Options());
            IOUtils.copy((InputStream)bis, (OutputStream)cos);
            FileUtils.closeQuietly((OutputStream)cos);
            byArray = bos.toByteArray();
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                String msg = "Failed to compress bytes!";
                LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                errors.add(msg, (Throwable)e);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(cos);
                FileUtils.closeQuietly(bos);
                FileUtils.closeQuietly((InputStream)bis);
                throw throwable;
            }
            FileUtils.closeQuietly((OutputStream)cos);
            FileUtils.closeQuietly((OutputStream)bos);
            FileUtils.closeQuietly((InputStream)bis);
            return byArray2;
        }
        FileUtils.closeQuietly((OutputStream)cos);
        FileUtils.closeQuietly((OutputStream)bos);
        FileUtils.closeQuietly((InputStream)bis);
        return byArray;
    }

    public static byte[] decompress(byte[] input, int buffer) {
        return XzUtils.decompress(input, buffer, new MessageCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] input, int buffer, MessageCollection errors) {
        byte[] byArray;
        XZInputStream cis = null;
        ByteArrayOutputStream bos = null;
        try {
            cis = new XZInputStream((InputStream)new ByteArrayInputStream(input));
            bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)cis, (OutputStream)bos, (int)buffer);
            byArray = bos.toByteArray();
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                String msg = "Failed to decompress bytes!";
                LOGGER.log(Level.SEVERE, msg, (Throwable)e);
                errors.add(msg, (Throwable)e);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(cis);
                FileUtils.closeQuietly(bos);
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)cis);
            FileUtils.closeQuietly((OutputStream)bos);
            return byArray2;
        }
        FileUtils.closeQuietly((InputStream)cis);
        FileUtils.closeQuietly((OutputStream)bos);
        return byArray;
    }
}

