/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.filesearch;

import adams.core.exception.ExceptionHandler;
import adams.core.io.FileUtils;
import adams.core.io.filesearch.AbstractMetaFileSearchHandlerWithEncoding;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.tukaani.xz.XZInputStream;

public class XzFileSearchHandler
extends AbstractMetaFileSearchHandlerWithEncoding {
    private static final long serialVersionUID = 2030528214619565963L;

    public String globalInfo() {
        return "Searches xz-compressed (text) files.";
    }

    public boolean handles(String file) {
        return file.toLowerCase().endsWith(".xz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchFile(String file, String searchText, boolean caseSensitive, ExceptionHandler handler) {
        boolean result;
        block6: {
            result = false;
            FileInputStream fis = null;
            XZInputStream cis = null;
            InputStreamReader isr = null;
            this.m_Stopped = false;
            try {
                fis = new FileInputStream(file);
                cis = new XZInputStream((InputStream)new BufferedInputStream(fis));
                isr = new InputStreamReader((InputStream)cis, this.m_Encoding.charsetValue());
                result = this.m_Handler.searchStream((Reader)isr, searchText, caseSensitive, handler);
                FileUtils.closeQuietly((Reader)isr);
            }
            catch (Exception e) {
                if (handler != null) {
                    handler.handleException("Failed to search: " + file, (Throwable)e);
                }
                break block6;
            }
            finally {
                FileUtils.closeQuietly(isr);
                FileUtils.closeQuietly(cis);
                FileUtils.closeQuietly((InputStream)fis);
            }
            FileUtils.closeQuietly((InputStream)cis);
            FileUtils.closeQuietly((InputStream)fis);
        }
        return result;
    }
}

