/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.filesearch;

import adams.core.exception.ExceptionHandler;
import adams.core.io.FileUtils;
import adams.core.io.filesearch.AbstractMetaFileSearchHandlerWithEncoding;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipFileSearchHandler
extends AbstractMetaFileSearchHandlerWithEncoding {
    private static final long serialVersionUID = 2030528214619565963L;

    public String globalInfo() {
        return "Searches zip-compressed (text) files.";
    }

    public boolean handles(String file) {
        return file.toLowerCase().endsWith(".zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean searchFile(String file, String searchText, boolean caseSensitive, ExceptionHandler handler) {
        boolean result = false;
        ZipFile archive = null;
        this.m_Stopped = false;
        try {
            archive = new ZipFile(file);
            Enumeration enm = archive.getEntries();
            while (enm.hasMoreElements()) {
                if (this.m_Stopped) {
                    return result;
                }
                ZipArchiveEntry entry = (ZipArchiveEntry)enm.nextElement();
                if (entry.isDirectory()) continue;
                BufferedInputStream in = null;
                InputStreamReader isr = null;
                try {
                    in = new BufferedInputStream(archive.getInputStream(entry));
                    isr = new InputStreamReader((InputStream)in, this.m_Encoding.charsetValue());
                    result = this.m_Handler.searchStream((Reader)isr, searchText, caseSensitive, handler);
                }
                catch (Exception e) {
                    block18: {
                        try {
                            if (handler == null) break block18;
                            handler.handleException("Failed to zip/entry: " + file + "/" + entry.getName(), (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            FileUtils.closeQuietly(isr);
                            FileUtils.closeQuietly(in);
                            throw throwable;
                            return result;
                        }
                    }
                    FileUtils.closeQuietly(isr);
                    FileUtils.closeQuietly((InputStream)in);
                    continue;
                }
                FileUtils.closeQuietly((Reader)isr);
                FileUtils.closeQuietly((InputStream)in);
            }
        }
        catch (Exception e) {
            if (handler == null) return result;
            handler.handleException("Failed to search: " + file, (Throwable)e);
            return result;
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

