/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import gnu.trove.list.TByteList;
import gnu.trove.list.array.TByteArrayList;
import java.io.File;

public abstract class AbstractSingleCompress
extends AbstractTransformer {
    private static final long serialVersionUID = -7648311276417258437L;
    protected boolean m_RemoveInputFile;
    protected PlaceholderFile m_Output;
    protected int m_BufferSize;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remove", "removeInputFile", (Object)false);
        this.m_OptionManager.add("output", "output", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("buffer", "bufferSize", (Object)1024, (Number)1, null);
    }

    protected abstract String getDefaultExtension();

    public void setRemoveInputFile(boolean value) {
        this.m_RemoveInputFile = value;
        this.reset();
    }

    public boolean getRemoveInputFile() {
        return this.m_RemoveInputFile;
    }

    public String removeInputFileTipText() {
        return "If set to true, then the original input file will be deleted after a successful compression.";
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value;
        this.reset();
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public abstract String outputTipText();

    public void setBufferSize(int value) {
        if (this.getOptionManager().isValid("bufferSize", (Number)value)) {
            this.m_BufferSize = value;
            this.reset();
        }
    }

    public int getBufferSize() {
        return this.m_BufferSize;
    }

    public String bufferSizeTipText() {
        return "The size of the buffer in bytes for the data stream.";
    }

    public String getQuickInfo() {
        String result = "output is ";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"output", (Object)(this.m_Output.isDirectory() ? "<incoming>" + this.getDefaultExtension() : this.m_Output));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"removeInputFile", (boolean)this.m_RemoveInputFile, (String)"remove <incoming>", (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class, byte[].class};
    }

    public Class[] generates() {
        return new Class[]{String.class, byte[].class};
    }

    protected abstract String compress(File var1, File var2);

    protected abstract String compress(byte[] var1, TByteList var2);

    protected String doExecute() {
        String result = null;
        File inFile = null;
        byte[] inBytes = null;
        if (this.m_InputToken.hasPayload(File.class)) {
            inFile = (File)this.m_InputToken.getPayload(File.class);
        } else if (this.m_InputToken.hasPayload(String.class)) {
            inFile = new PlaceholderFile((String)this.m_InputToken.getPayload(String.class));
        } else if (this.m_InputToken.hasPayload(byte[].class)) {
            inBytes = (byte[])this.m_InputToken.getPayload(byte[].class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (result == null) {
            if (inFile != null) {
                String output = this.m_Output.isDirectory() ? inFile.getAbsolutePath() + this.getDefaultExtension() : this.m_Output.getAbsolutePath();
                File outFile = new File(output);
                result = this.compress(inFile, outFile);
                if (result == null) {
                    this.m_OutputToken = new Token((Object)output);
                }
            } else if (inBytes != null) {
                TByteArrayList outBytes = new TByteArrayList();
                result = this.compress(inBytes, (TByteList)outBytes);
                if (result == null) {
                    this.m_OutputToken = new Token((Object)outBytes.toArray());
                }
            } else {
                result = "Neither file nor bytes for input?";
            }
        }
        return result;
    }
}

