/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.io.LzfUtils;
import adams.flow.transformer.AbstractSingleCompress;
import gnu.trove.list.TByteList;
import java.io.File;

public class Lzf
extends AbstractSingleCompress {
    private static final long serialVersionUID = 6833577217007229726L;

    public String globalInfo() {
        return "Creates a LZF archive from a single file. Outputs the filename of the LZF file generated. Optionally, the original input file can be deleted.\n\nMore information see here:\nhttp://en.wikibooks.org/wiki/Data_Compression/Dictionary_compression#LZF";
    }

    @Override
    public String outputTipText() {
        return "The LZF file to create; if pointing to a directory, then the output filename is based on the file that is being compressed and the '.lzf' extension added.";
    }

    @Override
    protected String getDefaultExtension() {
        return ".lzf";
    }

    @Override
    protected String compress(File inFile, File outFile) {
        return LzfUtils.compress(inFile, this.m_BufferSize, outFile, this.m_RemoveInputFile);
    }

    @Override
    protected String compress(byte[] inBytes, TByteList outBytes) {
        MessageCollection errors = new MessageCollection();
        byte[] compressed = LzfUtils.compress(inBytes, errors);
        if (compressed == null) {
            return errors.isEmpty() ? "Failed to compress!" : errors.toString();
        }
        outBytes.addAll(compressed);
        return null;
    }
}

