/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.io.ZstdUtils;
import adams.flow.transformer.AbstractSingleCompress;
import gnu.trove.list.TByteList;
import java.io.File;

public class Zstd
extends AbstractSingleCompress {
    private static final long serialVersionUID = -4692431747542097656L;

    public String globalInfo() {
        return "Creates a Zstd archive from a single file. Outputs the filename of the Zstd file generated. Optionally, the original input file can be deleted.";
    }

    @Override
    public String outputTipText() {
        return "The Zstd file to create; if pointing to a directory, then the output filename is based on the file that is being compressed and the '.zst' extension added.";
    }

    @Override
    protected String getDefaultExtension() {
        return ".zst";
    }

    @Override
    protected String compress(File inFile, File outFile) {
        return ZstdUtils.compress(inFile, this.m_BufferSize, outFile, this.m_RemoveInputFile);
    }

    @Override
    protected String compress(byte[] inBytes, TByteList outBytes) {
        MessageCollection errors = new MessageCollection();
        byte[] compressed = ZstdUtils.compress(inBytes);
        if (compressed == null) {
            return "Failed to compress!";
        }
        outBytes.addAll(compressed);
        return null;
    }
}

