/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.filecommander;

import adams.core.io.PlaceholderFile;
import adams.core.io.ZipUtils;
import adams.gui.core.GUIHelper;
import adams.gui.tools.filecommander.AbstractFileCommanderAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.SwingWorker;

public class Zip
extends AbstractFileCommanderAction {
    private static final long serialVersionUID = -8374323161691034031L;

    public Zip() {
        this.setName("ZIP");
    }

    protected void doActionPerformed(ActionEvent e) {
        final String zip = GUIHelper.showInputDialog((Component)this.getOwner(), (String)"Please enter the name for the ZIP file", (String)"compressed.zip");
        if (zip == null) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                String regExp;
                File[] files = Zip.this.getOwner().getActive().getFilePanel().getSelectedFiles();
                PlaceholderFile zipFile = new PlaceholderFile(Zip.this.getOwner().getActive().getFilePanel().getCurrentDir() + "/" + zip);
                String msg = ZipUtils.compress((File)zipFile, files, regExp = Zip.this.getOwner().getActive().getFilePanel().getCurrentDir().replace("/", ".").replace("\\", "."), 1024);
                if (msg != null) {
                    GUIHelper.showErrorMessage((Component)Zip.this.getOwner(), (String)("Failed to create ZIP file:\n" + zipFile + "\n" + msg));
                } else {
                    Zip.this.getOwner().getActive().reload();
                    Zip.this.showStatus("Created ZIP file: " + zipFile);
                }
                return null;
            }
        };
        worker.execute();
    }

    public void update() {
        boolean local = this.getOwner().getActive().getFilePanel().isLocal();
        this.setEnabled(local && this.getOwner().getActive().getFilePanel().getSelectedFiles().length > 0);
    }
}

