/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.multiobjectexport;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.FileWriter;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.core.io.ZipUtils;
import adams.gui.visualization.debug.objectexport.AbstractObjectExporter;
import adams.gui.visualization.multiobjectexport.AbstractMultiObjectExportWithPreferredExtensions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ZipExport
extends AbstractMultiObjectExportWithPreferredExtensions
implements FileWriter {
    private static final long serialVersionUID = -8530263811736177464L;
    protected PlaceholderFile m_OutputFile;
    protected String m_Prefix;

    public String globalInfo() {
        return "Exports the objects to the specified ZIP file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-file", "outputFile", (Object)new PlaceholderFile());
        this.m_OptionManager.add("prefix", "prefix", (Object)"");
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The ZIP file to store the files in that get generated from the objects.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The optional prefix for the files (<prefix><name>.<ext>).";
    }

    protected String doExport(String[] names, Object[] objects) {
        String msg;
        int i;
        for (i = 0; i < names.length; ++i) {
            names[i] = FileUtils.createFilename((String)(this.m_Prefix + names[i]), (String)"");
        }
        names = this.disambiguateNames(names);
        MessageCollection errors = new MessageCollection();
        File outputDir = TempUtils.createTempFile((String)"zipexport", (String)"");
        if (!outputDir.mkdirs()) {
            errors.add("Failed to create temporary output directory: " + outputDir);
        }
        ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
        if (errors.isEmpty()) {
            for (i = 0; i < names.length; ++i) {
                List exporters = this.determineExporters(names[i], objects[i], errors);
                for (AbstractObjectExporter exporter : exporters) {
                    String ext = this.determineExtension(exporter);
                    PlaceholderFile file = new PlaceholderFile(outputDir.getAbsolutePath() + File.separator + names[i] + "." + ext);
                    msg = exporter.export(objects[i], (File)file);
                    if (msg != null) {
                        errors.add("Failed to find export '" + names[i] + "'/" + Utils.classToString((Object)objects[i]) + "\n" + msg);
                        continue;
                    }
                    files.add(file);
                }
            }
        }
        if (errors.isEmpty() && (msg = ZipUtils.compress((File)this.m_OutputFile, files.toArray(new File[files.size()]), ".*", 1024)) != null) {
            errors.add("Failed to generated ZIP file: " + this.m_OutputFile + "\n" + msg);
        }
        if (outputDir.exists()) {
            FileUtils.delete((File)outputDir);
        }
        if (errors.isEmpty()) {
            return null;
        }
        return errors.toString();
    }
}

