/*
 * Decompiled with CFR 0.152.
 */
package adams.tools;

import adams.core.Performance;
import adams.core.StoppableWithFeedback;
import adams.core.ThreadLimiter;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.password.BruteForcePasswordGenerator;
import adams.core.password.DictionaryBasedGenerator;
import adams.env.Environment;
import adams.flow.core.RunnableWithLogging;
import adams.multiprocess.PausableFixedThreadPoolExecutor;
import adams.tools.AbstractTool;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.lingala.zip4j.core.ZipFile;

public class ZipPassword
extends AbstractTool
implements ThreadLimiter {
    private static final long serialVersionUID = 3018437869824414157L;
    public static final String DEFAULT_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.,;:'\"-_!@#$%^&*()[]{}";
    protected PlaceholderFile m_Zip;
    protected PlaceholderFile m_Dictionary;
    protected String m_Characters;
    protected int m_MaxLength;
    protected String m_Start;
    protected int m_NumThreads;
    protected PlaceholderFile m_Password;
    protected boolean m_Finished;
    protected PausableFixedThreadPoolExecutor m_Executor;
    protected List<BruteForceJob> m_Jobs;

    public String globalInfo() {
        return "Attempts to determine the password of a password protected ZIP file.\nIf no dictionary file has been provided, a brute force attack is carried out.\nThe brute force attack can be run in parallel, default is two threads.\nThe dictionary approach also tests lower/upper case version of the passwords and the reverse of them.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("zip", "zip", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("dictionary", "dictionary", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("chars", "characters", (Object)DEFAULT_CHARS);
        this.m_OptionManager.add("max-length", "maxLength", (Object)10, (Number)1, null);
        this.m_OptionManager.add("start", "start", (Object)"");
        this.m_OptionManager.add("num-threads", "numThreads", (Object)2);
        this.m_OptionManager.add("password", "password", (Object)new PlaceholderFile("."));
    }

    public void setZip(PlaceholderFile value) {
        this.m_Zip = value;
        this.reset();
    }

    public PlaceholderFile getZip() {
        return this.m_Zip;
    }

    public String zipTipText() {
        return "The ZIP file to process.";
    }

    public void setDictionary(PlaceholderFile value) {
        this.m_Dictionary = value;
        this.reset();
    }

    public PlaceholderFile getDictionary() {
        return this.m_Dictionary;
    }

    public String dictionaryTipText() {
        return "The dictionary file to process.";
    }

    public void setCharacters(String value) {
        this.m_Characters = value;
        this.reset();
    }

    public String getCharacters() {
        return this.m_Characters;
    }

    public String charactersTipText() {
        return "The characters to use for brute force attack.";
    }

    public void setMaxLength(int value) {
        this.m_MaxLength = value;
        this.reset();
    }

    public int getMaxLength() {
        return this.m_MaxLength;
    }

    public String maxLengthTipText() {
        return "The maximum length for password strings when performing brute force attack.";
    }

    public void setStart(String value) {
        this.m_Start = value;
        this.reset();
    }

    public String getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The starting password for the brute force attack.";
    }

    public void setNumThreads(int value) {
        this.m_NumThreads = value;
        this.reset();
    }

    public int getNumThreads() {
        return this.m_NumThreads;
    }

    public String numThreadsTipText() {
        return Performance.getNumThreadsHelp();
    }

    public void setPassword(PlaceholderFile value) {
        this.m_Password = value;
        this.reset();
    }

    public PlaceholderFile getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The file to store the password in (if one found).";
    }

    protected void preRun() {
        super.preRun();
        if (!this.m_Zip.exists()) {
            throw new IllegalArgumentException("ZIP file does not exist: " + this.m_Zip);
        }
        if (this.m_Zip.isDirectory()) {
            throw new IllegalArgumentException("ZIP file points to directory: " + this.m_Zip);
        }
    }

    protected void doRunBruteForce() {
        int numThreads = Performance.determineNumThreads((int)this.m_NumThreads);
        this.m_Executor = new PausableFixedThreadPoolExecutor(numThreads);
        this.m_Jobs = new ArrayList<BruteForceJob>();
        for (int i = 0; i < numThreads; ++i) {
            BruteForcePasswordGenerator generator = new BruteForcePasswordGenerator(this.m_Characters, this.m_MaxLength, this.m_Start.isEmpty() ? null : this.m_Start);
            for (int n = 0; n < i; ++n) {
                generator.next();
            }
            BruteForceJob job = new BruteForceJob(this, i, generator, numThreads - 1, (File)this.m_Zip);
            job.setLoggingLevel(this.getLoggingLevel());
            this.m_Jobs.add(job);
        }
        for (BruteForceJob j : this.m_Jobs) {
            this.m_Executor.submit((Runnable)((Object)j));
        }
        while (!this.m_Stopped && !this.m_Executor.isTerminated()) {
            Utils.wait((LoggingSupporter)this, (StoppableWithFeedback)this, (int)1000, (int)1000);
        }
    }

    protected void doRunDictionary() {
        try {
            ZipFile zipfile = new ZipFile(this.m_Zip.getAbsolutePath());
            if (!zipfile.isEncrypted()) {
                this.getLogger().warning("ZIP file is not encrypted: " + this.m_Zip);
                this.outputPassword(null);
                return;
            }
            DictionaryBasedGenerator generator = new DictionaryBasedGenerator(this.m_Dictionary, DictionaryBasedGenerator.Variation.values());
            String tmpDir = TempUtils.getTempDirectoryStr();
            this.getLogger().info("");
            int count = 0;
            while (generator.hasNext()) {
                if (this.m_Stopped) {
                    this.getLogger().severe("Interrupted!");
                    this.outputPassword(null);
                    return;
                }
                ++count;
                String password = generator.next();
                try {
                    zipfile.setPassword(password);
                    zipfile.extractAll(tmpDir);
                    this.outputPassword(password);
                    return;
                }
                catch (Exception exception) {
                    if (count % 10000 != 0) continue;
                    this.getLogger().info(password);
                    count = 0;
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error accessing ZIP file: " + this.m_Zip, (Throwable)e);
        }
    }

    protected synchronized void outputPassword(String password) {
        if (this.m_Finished) {
            return;
        }
        this.m_Finished = true;
        this.stopExecution();
        if (password == null) {
            this.getLogger().severe("Failed to determine password!");
        } else if (this.m_Password.isDirectory()) {
            System.out.println(password);
        } else {
            FileUtils.writeToFile((String)this.m_Password.getAbsolutePath(), (Object)password, (boolean)false);
        }
    }

    protected void doRun() {
        this.m_Finished = false;
        if (!this.m_Dictionary.exists() || this.m_Dictionary.isDirectory()) {
            this.doRunBruteForce();
        } else {
            this.doRunDictionary();
        }
    }

    public void stopExecution() {
        super.stopExecution();
        if (this.m_Executor != null) {
            for (BruteForceJob job : this.m_Jobs) {
                job.stopExecution();
            }
            try {
                if (this.m_Executor.isPaused()) {
                    this.m_Executor.resumeExecution();
                }
                this.m_Executor.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_Executor = null;
        }
    }

    public static void main(String[] args) throws Exception {
        ZipPassword.runTool(Environment.class, ZipPassword.class, (String[])args);
    }

    public static class BruteForceJob
    extends RunnableWithLogging {
        private static final long serialVersionUID = -4788228040850442732L;
        protected ZipPassword m_Owner;
        protected int m_ID;
        protected BruteForcePasswordGenerator m_Generator;
        protected int m_Skip;
        protected File m_Zip;

        public BruteForceJob(ZipPassword owner, int id, BruteForcePasswordGenerator generator, int skip, File zip) {
            this.m_Owner = owner;
            this.m_ID = id;
            this.m_Generator = generator;
            this.m_Skip = skip;
            this.m_Zip = zip;
            this.m_Logger = null;
        }

        protected void configureLogger() {
            this.m_Logger = LoggingHelper.getLogger((String)(((Object)((Object)this)).getClass() + "-" + this.m_ID));
            this.m_Logger.setLevel(this.m_LoggingLevel.getLevel());
        }

        protected void doRun() {
            try {
                ZipFile zipfile = new ZipFile(this.m_Zip.getAbsolutePath());
                if (!zipfile.isEncrypted()) {
                    this.getLogger().warning("ZIP file is not encrypted: " + this.m_Zip);
                    this.m_Owner.outputPassword(null);
                    return;
                }
                int count = 0;
                String tmpDir = TempUtils.getTempDirectoryStr();
                while (!this.m_Stopped && this.m_Generator.hasNext()) {
                    ++count;
                    String password = this.m_Generator.next();
                    try {
                        zipfile.setPassword(password);
                        zipfile.extractAll(tmpDir);
                        this.m_Owner.outputPassword(password);
                        return;
                    }
                    catch (Exception exception) {
                        if (count % 10000 == 0) {
                            this.getLogger().info(password);
                            count = 0;
                        }
                        for (int i = 0; i < this.m_Skip; ++i) {
                            this.m_Generator.next();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error processing ZIP file: " + this.m_Zip, (Throwable)e);
            }
        }
    }
}

