/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingObject;
import adams.db.AbstractDatabaseConnection;
import adams.env.Environment;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.parser.sql.SQLParser;
import com.googlecode.cqengine.resultset.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;

public abstract class AbstractCQETable<T>
extends LoggingObject {
    private static final long serialVersionUID = 8540313627448845885L;
    public static final String FILENAME = "CQETable.props";
    protected static Properties m_Properties;
    protected static Logger LOGGER;
    protected static SQLParser m_Parser;
    protected String m_TableName;
    protected boolean m_Debug;
    protected AbstractDatabaseConnection m_DatabaseConnection;
    protected IndexedCollection<T> m_Collection;

    public AbstractCQETable(AbstractDatabaseConnection dbcon, String tableName) {
        this.m_TableName = tableName;
        this.m_DatabaseConnection = dbcon;
        this.m_Collection = this.newCollection();
        this.m_Debug = AbstractCQETable.getProperties().getBoolean(((Object)((Object)this)).getClass().getName() + ".Debug", Boolean.valueOf(false));
        if (m_Parser == null) {
            m_Parser = this.newParser();
        }
        this.updatePrefix();
    }

    public String getTableName() {
        return this.m_TableName;
    }

    protected abstract SQLParser<T> newParser();

    public SQLParser<T> getParser() {
        return m_Parser;
    }

    protected abstract IndexedCollection<T> newCollection();

    public IndexedCollection<T> getCollection() {
        return this.m_Collection;
    }

    public void clear() {
        this.m_Collection.clear();
    }

    protected void updatePrefix() {
        String prefix = ((Object)((Object)this)).getClass().getName() + "(" + this.getDatabaseConnection().toStringShort() + "/" + this.getDatabaseConnection().hashCode() + ")";
        this.m_Logger = LoggingHelper.getLogger((String)prefix);
        this.m_Logger.setLevel(this.getDebug() ? Level.INFO : Level.OFF);
    }

    public static String backquote(BaseRegExp s) {
        return AbstractCQETable.backquote(s.getValue());
    }

    public static String backquote(String s) {
        String result = Utils.backQuoteChars((String)s);
        if (!result.startsWith("'")) {
            result = "'" + result + "'";
        }
        return result;
    }

    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    public void setDebug(boolean value) {
        this.m_Debug = value;
        this.getLogger().setLevel(value ? Level.INFO : Level.WARNING);
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public boolean isThere(String condition) {
        try {
            ResultSet<T> rs = this.select(condition);
            Iterator iter = rs.iterator();
            if (!iter.hasNext()) {
                AbstractCQETable.closeAll(rs);
                return false;
            }
            AbstractCQETable.closeAll(rs);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isThere(Query<T> query) {
        try {
            ResultSet rs = this.getCollection().retrieve(query);
            Iterator iter = rs.iterator();
            if (!iter.hasNext()) {
                AbstractCQETable.closeAll(rs);
                return false;
            }
            AbstractCQETable.closeAll(rs);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ResultSet<T> select(String where) throws Exception {
        return this.doSelect(false, where);
    }

    public ResultSet<T> selectDistinct(String where) throws Exception {
        return this.doSelect(true, where);
    }

    protected ResultSet<T> doSelect(boolean distinct, String where) throws Exception {
        String query = "SELECT ";
        if (distinct) {
            query = query + "DISTINCT ";
        }
        query = query + "*";
        query = query + " FROM " + this.getTableName();
        if (where != null && where.length() > 0) {
            if (!where.trim().toUpperCase().startsWith("LIMIT ") && !where.trim().toUpperCase().startsWith("ORDER ")) {
                query = query + " WHERE";
            }
            query = query + " " + where;
        }
        this.getLogger().info("doSelect: " + query);
        try {
            return this.getParser().retrieve(this.getCollection(), query);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to execute query: " + query, (Throwable)e);
            throw e;
        }
    }

    protected boolean remove(ResultSet<T> rs) {
        boolean result;
        ArrayList objs = new ArrayList();
        Iterator iter = rs.iterator();
        while (iter.hasNext()) {
            objs.add(iter.next());
        }
        AbstractCQETable.closeAll(rs);
        if (this.getDebug()) {
            this.getLogger().info("Removing " + objs.size() + " object(s)");
        }
        try {
            result = this.getCollection().removeAll(objs);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to remove objects!", (Throwable)e);
            return false;
        }
        if (this.getDebug()) {
            this.getLogger().info("Removed: " + result);
            this.getLogger().info("Size: " + this.getCollection().size());
        }
        return result;
    }

    public static void closeAll(ResultSet r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error closing resultset", (Throwable)e);
            }
        }
    }

    public static boolean isEnabled(Class table) {
        return AbstractCQETable.getProperties().getBoolean(table.getName() + ".Enabled", Boolean.valueOf(false));
    }

    protected static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("cqe table");
        }
        return m_Properties;
    }

    static {
        LOGGER = LoggingHelper.getConsoleLogger(AbstractCQETable.class);
    }
}

