/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.db.AbstractCQETable;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseManager;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;

public class CQETableManager<T extends AbstractCQETable>
implements Serializable {
    private static final long serialVersionUID = 7054134442727870486L;
    protected String m_CQEName;
    protected HashMap<String, T> m_CQEs;
    protected DatabaseManager m_DatabaseManager;

    public CQETableManager(String cqeName, DatabaseManager manager) {
        this.m_CQEName = cqeName;
        this.m_CQEs = new HashMap();
        this.m_DatabaseManager = manager;
    }

    public String getCQEName() {
        return this.m_CQEName;
    }

    public boolean hasDatabaseManager() {
        return this.m_DatabaseManager != null;
    }

    public DatabaseManager getDatabaseManager() {
        return this.m_DatabaseManager;
    }

    protected String createURL(AbstractDatabaseConnection dbcon) {
        return dbcon.getUser() + ":" + dbcon.getPassword() + "@" + dbcon.getURL();
    }

    public boolean has(AbstractDatabaseConnection dbcon) {
        if (dbcon == null) {
            dbcon = this.getDatabaseManager().getDefault();
        }
        return this.m_CQEs.containsKey(this.createURL(dbcon));
    }

    public T get(AbstractDatabaseConnection dbcon) {
        if (dbcon == null) {
            dbcon = this.getDatabaseManager().getDefault();
        }
        return (T)((Object)((AbstractCQETable)((Object)this.m_CQEs.get(this.createURL(dbcon)))));
    }

    public T add(AbstractDatabaseConnection dbcon, T cqe) {
        if (dbcon == null) {
            if (this.hasDatabaseManager()) {
                dbcon = this.getDatabaseManager().getDefault();
            } else {
                return null;
            }
        }
        AbstractCQETable result = (AbstractCQETable)((Object)this.m_CQEs.put(this.createURL(dbcon), cqe));
        dbcon.addChangeListener(new DatabaseConnectionChangeListener(){

            public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
                if (e.getType() == DatabaseConnectionChangeEvent.EventType.DISCONNECT) {
                    e.getDatabaseConnection().removeChangeListener((DatabaseConnectionChangeListener)this);
                    CQETableManager.this.m_CQEs.remove(CQETableManager.this.createURL(e.getDatabaseConnection()));
                }
            }
        });
        return (T)((Object)result);
    }

    public Iterator<T> iterator() {
        return this.m_CQEs.values().iterator();
    }

    public String toString() {
        return this.getCQEName() + ": " + this.m_CQEs.keySet();
    }
}

