/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.VariableName;
import adams.core.base.BaseRegExp;
import adams.core.base.CronSchedule;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.condition.bool.Expression;
import adams.flow.control.Flow;
import adams.flow.control.IfThenElse;
import adams.flow.control.Sequence;
import adams.flow.control.Sleep;
import adams.flow.control.Stop;
import adams.flow.control.Tee;
import adams.flow.control.WhileLoop;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.Start;
import adams.flow.source.Variable;
import adams.flow.standalone.Cron;
import adams.flow.standalone.DeleteFile;
import adams.flow.standalone.Events;
import adams.flow.standalone.SetVariable;
import adams.flow.transformer.IncVariable;
import adams.parser.BooleanExpressionText;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class CronTest
extends AbstractFlowTest {
    public CronTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(CronTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[5];
            DeleteFile tmp2 = new DeleteFile();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("directory");
            tmp2.setDirectory((PlaceholderDirectory)argOption.valueOf("${TMP}"));
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("regExp");
            tmp2.setRegExp((BaseRegExp)argOption.valueOf("dumpfile.txt"));
            tmp1[0] = tmp2;
            SetVariable tmp5 = new SetVariable();
            argOption = (AbstractArgumentOption)tmp5.getOptionManager().findByProperty("variableName");
            tmp5.setVariableName((VariableName)argOption.valueOf("counter"));
            argOption = (AbstractArgumentOption)tmp5.getOptionManager().findByProperty("variableValue");
            tmp5.setVariableValue((String)argOption.valueOf("0"));
            tmp1[1] = tmp5;
            Events tmp8 = new Events();
            argOption = (AbstractArgumentOption)tmp8.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp9 = new AbstractActor[1];
            Cron tmp10 = new Cron();
            argOption = (AbstractArgumentOption)tmp10.getOptionManager().findByProperty("cronActors");
            AbstractActor[] tmp11 = new AbstractActor[4];
            Variable tmp12 = new Variable();
            argOption = (AbstractArgumentOption)tmp12.getOptionManager().findByProperty("variableName");
            tmp12.setVariableName((VariableName)argOption.valueOf("counter"));
            tmp11[0] = tmp12;
            IncVariable tmp14 = new IncVariable();
            argOption = (AbstractArgumentOption)tmp14.getOptionManager().findByProperty("variableName");
            tmp14.setVariableName((VariableName)argOption.valueOf("counter"));
            tmp11[1] = tmp14;
            Tee tmp16 = new Tee();
            argOption = (AbstractArgumentOption)tmp16.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp17 = new AbstractActor[1];
            DumpFile tmp18 = new DumpFile();
            argOption = (AbstractArgumentOption)tmp18.getOptionManager().findByProperty("outputFile");
            tmp18.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
            tmp18.setAppend(true);
            tmp17[0] = tmp18;
            tmp16.setActors(tmp17);
            tmp11[2] = tmp16;
            IfThenElse tmp20 = new IfThenElse();
            argOption = (AbstractArgumentOption)tmp20.getOptionManager().findByProperty("condition");
            Expression tmp22 = new Expression();
            argOption = (AbstractArgumentOption)tmp22.getOptionManager().findByProperty("expression");
            tmp22.setExpression(new BooleanExpressionText("@{counter} = 3"));
            tmp20.setCondition((AbstractBooleanCondition)tmp22);
            argOption = (AbstractArgumentOption)tmp20.getOptionManager().findByProperty("thenActor");
            Sequence tmp25 = new Sequence();
            argOption = (AbstractArgumentOption)tmp25.getOptionManager().findByProperty("name");
            tmp25.setName((String)argOption.valueOf("then"));
            argOption = (AbstractArgumentOption)tmp25.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp27 = new AbstractActor[1];
            Stop tmp28 = new Stop();
            tmp27[0] = tmp28;
            tmp25.setActors(tmp27);
            tmp20.setThenActor((AbstractActor)tmp25);
            argOption = (AbstractArgumentOption)tmp20.getOptionManager().findByProperty("elseActor");
            Sequence tmp30 = new Sequence();
            argOption = (AbstractArgumentOption)tmp30.getOptionManager().findByProperty("name");
            tmp30.setName((String)argOption.valueOf("else"));
            tmp20.setElseActor((AbstractActor)tmp30);
            tmp11[3] = tmp20;
            tmp10.setCronActors(tmp11);
            argOption = (AbstractArgumentOption)tmp10.getOptionManager().findByProperty("schedule");
            tmp10.setSchedule((CronSchedule)argOption.valueOf("0/3 * * * * ?"));
            tmp9[0] = tmp10;
            tmp8.setActors(tmp9);
            tmp1[2] = tmp8;
            Start tmp33 = new Start();
            tmp1[3] = tmp33;
            WhileLoop tmp34 = new WhileLoop();
            argOption = (AbstractArgumentOption)tmp34.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp35 = new AbstractActor[2];
            Sleep tmp36 = new Sleep();
            tmp35[0] = new Start();
            tmp35[1] = tmp36;
            tmp34.setActors(tmp35);
            tmp1[4] = tmp34;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            CronTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        CronTest.runTest((Test)CronTest.suite());
    }
}

