/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.iterationlistener;

import adams.ml.dl4j.iterationlistener.AbstractIteratorListenerConfigurator;
import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageRouter;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.ui.api.UIServer;
import org.deeplearning4j.ui.stats.StatsListener;
import org.deeplearning4j.ui.storage.InMemoryStatsStorage;

public class InMemoryStatsListenerConfigurator
extends AbstractIteratorListenerConfigurator {
    private static final long serialVersionUID = -3325744412079265328L;
    protected int m_Frequency;

    public String globalInfo() {
        return "Configures a statistics listener (using in-memory storage), which allows you to monitor the progress at:\nhttp://localhost:9000/train";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("frequency", "frequency", (Object)1, (Number)1, null);
    }

    public void setFrequency(int value) {
        if (this.getOptionManager().isValid("frequency", (Number)value)) {
            this.m_Frequency = value;
            this.reset();
        }
    }

    public int getFrequency() {
        return this.m_Frequency;
    }

    public String frequencyTipText() {
        return "The update frequency.";
    }

    public boolean requiresFlowContext() {
        return false;
    }

    protected List<IterationListener> doConfigureIterationListeners() {
        UIServer uiServer = UIServer.getInstance();
        InMemoryStatsStorage statsStorage = new InMemoryStatsStorage();
        uiServer.attach((StatsStorage)statsStorage);
        return Arrays.asList(new StatsListener((StatsStorageRouter)statsStorage, this.m_Frequency));
    }
}

