/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import weka.core.Instance;

public class WekaInstanceToDL4JINDArray
extends AbstractConversion {
    private static final long serialVersionUID = -7278857064645982416L;

    public String globalInfo() {
        return "Converts a Weka Instance object to a DL4J INDArray.\nAssumes missing values to be imputed and nominal attributes to be binarized.";
    }

    public Class accepts() {
        return Instance.class;
    }

    public Class generates() {
        return INDArray.class;
    }

    protected Object doConvert() throws Exception {
        Instance inst = (Instance)this.m_Input;
        INDArray result = Nd4j.ones((int)1, (int)(inst.numAttributes() - 1));
        double[] independent = new double[inst.numAttributes() - 1];
        int index = 0;
        for (int i = 0; i < inst.numAttributes(); ++i) {
            if (i == inst.classIndex()) continue;
            independent[index++] = inst.value(i);
        }
        result.putRow(0, Nd4j.create((double[])independent));
        return result;
    }
}

