/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Utils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import weka.classifiers.functions.DL4JMultiLayerNetwork;
import weka.core.Instances;
import weka.filters.Filter;

public class DL4JInitWekaClassifier
extends AbstractTransformer {
    private static final long serialVersionUID = 7480758744491379628L;
    public static final String DEFAULT_ERROR = "Requires array of length 3: DL4J multi-layer network, trained Weka filter, original training data.";

    public String globalInfo() {
        return "Uses the incoming array to initialize a " + DL4JMultiLayerNetwork.class + " classifier.\nArray must consist of:\n- DL4J multi-layer network\n- trained Weka filter (used for preprocessing data)\n- original training data";
    }

    public Class[] accepts() {
        return new Class[]{Object[].class};
    }

    public Class[] generates() {
        return new Class[]{DL4JMultiLayerNetwork.class};
    }

    protected String doExecute() {
        String result = null;
        Object[] input = (Object[])this.m_InputToken.getPayload();
        if (input.length != 3) {
            result = "Array of length " + input.length + "! " + DEFAULT_ERROR;
        } else if (!(input[0] instanceof MultiLayerNetwork)) {
            result = "1st array element wrong (found: " + Utils.classToString((Object)input[0]) + ")! " + DEFAULT_ERROR;
        } else if (!(input[1] instanceof Filter)) {
            result = "2nd array element wrong (found: " + Utils.classToString((Object)input[1]) + ")! " + DEFAULT_ERROR;
        } else if (!(input[2] instanceof Instances)) {
            result = "3rd array element wrong (found: " + Utils.classToString((Object)input[2]) + ")! " + DEFAULT_ERROR;
        }
        if (result == null) {
            DL4JMultiLayerNetwork network = new DL4JMultiLayerNetwork();
            network.setTrainedMultiLayerNetwork((MultiLayerNetwork)input[0]);
            network.setTrainedPreFilter((Filter)input[1]);
            network.setTrainingData((Instances)input[2]);
            this.m_OutputToken = new Token((Object)network);
        }
        return result;
    }
}

