/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.dl4j;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.factory.Nd4j;
import weka.core.Instance;
import weka.core.Instances;

public class Utils {
    public static DataSet instancesToDataSet(Instances insts) {
        INDArray data = Nd4j.ones((int)insts.numInstances(), (int)(insts.numAttributes() - 1));
        double[][] outcomes = new double[insts.numInstances()][insts.classAttribute().numValues() == 0 ? 1 : insts.classAttribute().numValues()];
        for (int i = 0; i < insts.numInstances(); ++i) {
            double[] independent = new double[insts.numAttributes() - 1];
            int index = 0;
            Instance current = insts.instance(i);
            for (int j = 0; j < insts.numAttributes(); ++j) {
                if (j != insts.classIndex()) {
                    independent[index++] = current.value(j);
                    continue;
                }
                if (insts.numClasses() > 1) {
                    outcomes[i][(int)current.classValue()] = 1.0;
                    continue;
                }
                outcomes[i][0] = current.classValue();
            }
            data.putRow(i, Nd4j.create((double[])independent));
        }
        DataSet dataSet = new DataSet(data, Nd4j.create((double[][])outcomes));
        return dataSet;
    }

    public static DataSet RNNinstancesToDataSet(Instances insts) {
        INDArray data = Nd4j.ones((int[])new int[]{1, insts.numAttributes() - 1, insts.numInstances()});
        INDArray labels = Nd4j.ones((int[])new int[]{1, insts.numClasses(), insts.numInstances()});
        double[] outcomes = new double[insts.numInstances()];
        for (int i = 0; i < insts.numInstances(); ++i) {
            double[] independent = new double[insts.numAttributes() - 1];
            int index = 0;
            Instance current = insts.instance(i);
            for (int j = 0; j < insts.numAttributes(); ++j) {
                if (j != insts.classIndex()) {
                    independent[index++] = current.value(j);
                    continue;
                }
                outcomes[i] = current.classValue();
            }
            INDArray ind = Nd4j.create((double[])independent, (int[])new int[]{1, insts.numAttributes() - 1, 1});
            for (int k = 0; k < independent.length; ++k) {
                data.putScalar(0, k, i, ind.getDouble(k));
            }
        }
        INDArray outcomesNDArray = Nd4j.create((double[])outcomes, (int[])new int[]{1, insts.numInstances(), 1});
        labels.putColumn(0, outcomesNDArray);
        DataSet dataSet = new DataSet(data, labels);
        return dataSet;
    }

    public static INDArray instanceToINDArray(Instance inst) {
        INDArray result = Nd4j.ones((int)1, (int)(inst.numAttributes() - 1));
        double[] independent = new double[inst.numAttributes() - 1];
        int index = 0;
        for (int i = 0; i < inst.numAttributes(); ++i) {
            if (i == inst.classIndex()) continue;
            independent[index++] = inst.value(i);
        }
        result.putRow(0, Nd4j.create((double[])independent));
        return result;
    }
}

