/*
 * Decompiled with CFR 0.152.
 */
package weka.dl4j;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.datavec.api.split.InputSplit;
import org.datavec.api.util.ndarray.RecordConverter;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;
import org.datavec.image.loader.ImageLoader;
import org.datavec.image.recordreader.BaseImageRecordReader;
import org.nd4j.linalg.api.ndarray.INDArray;

public class EasyImageRecordReader
extends BaseImageRecordReader {
    protected static final long serialVersionUID = 3806752391833402426L;
    protected ArrayList<File> m_filenames = null;
    protected ArrayList<String> m_classes = null;
    protected Iterator<String> m_classIterator = null;
    protected Random m_random = null;

    public EasyImageRecordReader(int width, int height, int channels, ArrayList<File> filenames, ArrayList<String> classes, int seed) throws IOException {
        this.m_filenames = filenames;
        this.m_classes = classes;
        this.m_random = new Random(seed);
        this.initialize(null);
        this.imageLoader = new ImageLoader(width, height, channels);
    }

    public void initialize(InputSplit split) {
        long s = this.m_random.nextLong();
        Collections.shuffle(this.m_filenames, new Random(s));
        Collections.shuffle(this.m_classes, new Random(s));
        this.iter = this.m_filenames.listIterator();
        this.m_classIterator = this.m_classes.listIterator();
    }

    public List<Writable> next() {
        if (this.iter != null) {
            List<Object> ret = new ArrayList<Writable>();
            File image = (File)this.iter.next();
            String classLabel = this.m_classIterator.next();
            this.currentFile = image;
            if (image.isDirectory()) {
                return this.next();
            }
            try {
                INDArray row = this.imageLoader.asRowVector(image);
                ret = RecordConverter.toRecord((INDArray)row);
                if (classLabel != "?") {
                    ret.add((Writable)new DoubleWritable(Double.parseDouble(classLabel)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ret;
        }
        throw new IllegalStateException("No iterator or no more elements");
    }

    public void reset() {
        this.initialize(null);
    }

    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new IOException("Method record in EasyImageRecorder is not implemented.");
    }
}

