/*
 * Decompiled with CFR 0.152.
 */
package weka.dl4j;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;

public class FileIterationListener
implements IterationListener {
    private static final long serialVersionUID = 1948578564961956518L;
    protected transient PrintWriter m_pw = null;
    protected int m_numMiniBatches = 0;
    protected ArrayList<Double> lossesPerEpoch = new ArrayList();

    public FileIterationListener(String filename, int numMiniBatches) throws Exception {
        File f = new File(filename);
        if (f.exists()) {
            f.delete();
        }
        System.err.println("Creating debug file at: " + filename);
        this.m_numMiniBatches = numMiniBatches;
        this.m_pw = new PrintWriter(new FileWriter(filename, false));
        this.m_pw.write("loss\n");
    }

    public void invoke() {
    }

    public boolean invoked() {
        return false;
    }

    public void iterationDone(Model model, int epoch) {
        this.lossesPerEpoch.add(model.score());
        if (this.lossesPerEpoch.size() == this.m_numMiniBatches) {
            double mean = 0.0;
            for (double val : this.lossesPerEpoch) {
                mean += val;
            }
            this.m_pw.write((mean /= (double)this.lossesPerEpoch.size()) + "\n");
            this.m_pw.flush();
            this.lossesPerEpoch.clear();
        }
    }
}

