/*
 * Decompiled with CFR 0.152.
 */
package weka.dl4j.iterators;

import java.io.File;
import java.util.Enumeration;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import weka.classifiers.functions.dl4j.Utils;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionMetadata;
import weka.dl4j.ShufflingDataSetIterator;
import weka.dl4j.iterators.AbstractDataSetIterator;

public class ConvolutionalInstancesIterator
extends AbstractDataSetIterator {
    private static final long serialVersionUID = -3101209034945158130L;
    protected int m_height = 28;
    protected int m_width = 28;
    protected int m_numChannels = 1;
    protected File m_imagesLocation = new File(System.getProperty("user.dir"));

    @Override
    @OptionMetadata(displayName="size of mini batch", description="The mini batch size to use in the iterator (default = 1).", commandLineParamName="bs", commandLineParamSynopsis="-bs <int>", displayOrder=0)
    public void setTrainBatchSize(int trainBatchSize) {
        this.m_batchSize = trainBatchSize;
    }

    @Override
    public int getTrainBatchSize() {
        return this.m_batchSize;
    }

    @OptionMetadata(displayName="desired width", description="The desired width of the images (default = 28).", commandLineParamName="width", commandLineParamSynopsis="-width <int>", displayOrder=1)
    public int getWidth() {
        return this.m_width;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    @OptionMetadata(displayName="desired height", description="The desired height of the images (default = 28).", commandLineParamName="height", commandLineParamSynopsis="-height <int>", displayOrder=2)
    public int getHeight() {
        return this.m_height;
    }

    public void setHeight(int height) {
        this.m_height = height;
    }

    @OptionMetadata(displayName="desired number of channels", description="The desired number of channels (default = 1).", commandLineParamName="numChannels", commandLineParamSynopsis="-numChannels <int>", displayOrder=3)
    public int getNumChannels() {
        return this.m_numChannels;
    }

    public void setNumChannels(int numChannels) {
        this.m_numChannels = numChannels;
    }

    @Override
    public int getNumAttributes(Instances data) {
        return data.numAttributes() - 1;
    }

    @Override
    public DataSetIterator getIterator(Instances data, int seed, int batchSize) {
        DataSet dataset = Utils.instancesToDataSet(data);
        return new ShufflingDataSetIterator(dataset, batchSize, seed);
    }

    @Override
    public Enumeration<Option> listOptions() {
        return Option.listOptionsForClass(this.getClass()).elements();
    }

    @Override
    public String[] getOptions() {
        return Option.getOptions((Object)this, this.getClass());
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        Option.setOptions((String[])options, (Object)this, this.getClass());
    }
}

