/*
 * Decompiled with CFR 0.152.
 */
package weka.dl4j.iterators;

import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import weka.classifiers.functions.dl4j.Utils;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.dl4j.ShufflingDataSetIterator;
import weka.dl4j.iterators.AbstractDataSetIterator;

public class DefaultInstancesIterator
extends AbstractDataSetIterator {
    private static final long serialVersionUID = 1316260988724548474L;

    @Override
    @OptionMetadata(displayName="size of mini batch", description="The mini batch size to use in the iterator (default = 1).", commandLineParamName="bs", commandLineParamSynopsis="-bs <int>", displayOrder=1)
    public void setTrainBatchSize(int trainBatchSize) {
        this.m_batchSize = trainBatchSize;
    }

    @Override
    public int getTrainBatchSize() {
        return this.m_batchSize;
    }

    @Override
    public int getNumAttributes(Instances data) {
        return data.numAttributes() - 1;
    }

    @Override
    public DataSetIterator getIterator(Instances data, int seed, int batchSize) {
        DataSet dataset = Utils.instancesToDataSet(data);
        return new ShufflingDataSetIterator(dataset, batchSize, seed);
    }
}

