/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.conversion.AnyToString;
import adams.data.conversion.Conversion;
import adams.env.Environment;
import adams.flow.AbstractDL4JFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.DL4JModelConfigurator;
import adams.flow.transformer.Convert;
import adams.ml.dl4j.model.ModelConfigurator;
import adams.ml.dl4j.model.SimpleMultiLayerNetwork;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class DL4JModelConfiguratorTest
extends AbstractDL4JFlowTest {
    public DL4JModelConfiguratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(DL4JModelConfiguratorTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            DL4JModelConfigurator dl4jmodelsetup = new DL4JModelConfigurator();
            SimpleMultiLayerNetwork simplemultilayernetwork = new SimpleMultiLayerNetwork();
            dl4jmodelsetup.setModelConfigurator((ModelConfigurator)simplemultilayernetwork);
            actors.add(dl4jmodelsetup);
            Convert convert = new Convert();
            AnyToString any = new AnyToString();
            convert.setConversion((Conversion)any);
            actors.add(convert);
            DumpFile dumpfile = new DumpFile();
            AbstractArgumentOption argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            DL4JModelConfiguratorTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        DL4JModelConfiguratorTest.runTest((Test)DL4JModelConfiguratorTest.suite());
    }
}

