/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.ml.dl4j.datasetiterator.DataSetIteratorConfigurator;
import adams.ml.dl4j.datasetiterator.DataSetIteratorWithScriptedConfiguration;
import adams.ml.dl4j.datasetpreprocessor.DataSetPreProcessorConfigurator;
import adams.ml.dl4j.datasetpreprocessor.DataSetPreProcessorWithScriptedConfiguration;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class DL4JDatasetIterator
extends AbstractSource {
    private static final long serialVersionUID = 711203375341324288L;
    protected DataSetIteratorConfigurator m_Iterator;
    protected boolean m_UsePreProcessor;
    protected DataSetPreProcessorConfigurator m_PreProcessor;
    protected boolean m_NormalizeZeroMeanZeroUnitVariance;
    protected transient DataSetIterator m_ActualIterator;

    public String globalInfo() {
        return "Outputs datasets generated by the DL4J dataset iterator created by the specified configurator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("iterator", "iterator", (Object)new DataSetIteratorWithScriptedConfiguration());
        this.m_OptionManager.add("use-preprocessor", "usePreProcessor", (Object)false);
        this.m_OptionManager.add("preprocessor", "preProcessor", (Object)new DataSetPreProcessorWithScriptedConfiguration());
        this.m_OptionManager.add("normalize-zero-mean-zero-unit-variance", "normalizeZeroMeanZeroUnitVariance", (Object)false);
    }

    public void setIterator(DataSetIteratorConfigurator value) {
        this.m_Iterator = value;
        this.reset();
    }

    public DataSetIteratorConfigurator getIterator() {
        return this.m_Iterator;
    }

    public String iteratorTipText() {
        return "The iterator configurator to use for generating the dataset iterator that generates the data.";
    }

    public void setUsePreProcessor(boolean value) {
        this.m_UsePreProcessor = value;
        this.reset();
    }

    public boolean getUsePreProcessor() {
        return this.m_UsePreProcessor;
    }

    public String usePreProcessorTipText() {
        return "If enabled, uses the supplied preprocessor configurator to generate a preprocessor to be used with the iterator.";
    }

    public void setPreProcessor(DataSetPreProcessorConfigurator value) {
        this.m_PreProcessor = value;
        this.reset();
    }

    public DataSetPreProcessorConfigurator getPreProcessor() {
        return this.m_PreProcessor;
    }

    public String preProcessorTipText() {
        return "The preprocessor configurator to use for generating the dataset preprocessor that generates the data.";
    }

    public void setNormalizeZeroMeanZeroUnitVariance(boolean value) {
        this.m_NormalizeZeroMeanZeroUnitVariance = value;
        this.reset();
    }

    public boolean getNormalizeZeroMeanZeroUnitVariance() {
        return this.m_NormalizeZeroMeanZeroUnitVariance;
    }

    public String normalizeZeroMeanZeroUnitVarianceTipText() {
        return "If enabled, subtract by the column means and divide by the standard deviation.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"iterator", (Object)this.m_Iterator, (String)"iterator: ");
        if (this.m_UsePreProcessor || this.getOptionManager().hasVariableForProperty("usePreProcessor")) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"preProcessor", (Object)this.m_PreProcessor, (String)", preprocessor: ");
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        this.m_ActualIterator = this.m_Iterator.configureDataSetIterator();
        if (this.m_UsePreProcessor) {
            this.m_ActualIterator.setPreProcessor(this.m_PreProcessor.configureDataSetPreProcessor());
        }
        if (this.m_ActualIterator == null) {
            result = "Failed to configure dataset iterator!";
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{DataSet.class};
    }

    public Token output() {
        DataSet data = (DataSet)this.m_ActualIterator.next();
        if (this.m_NormalizeZeroMeanZeroUnitVariance) {
            data.normalizeZeroMeanZeroUnitVariance();
        }
        Token result = new Token((Object)data);
        if (!this.m_ActualIterator.hasNext()) {
            this.m_ActualIterator = null;
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_ActualIterator != null && this.m_ActualIterator.hasNext();
    }
}

