/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.base.BaseText;
import adams.core.option.OptionHandler;
import adams.flow.container.DL4JEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import org.deeplearning4j.eval.Evaluation;

public class DL4JEvaluationSummary
extends AbstractTransformer {
    private static final long serialVersionUID = 8082115424369061977L;
    protected boolean m_ConfusionMatrix;
    protected BaseText m_Comment;

    public String globalInfo() {
        return "Generates a summary string of the Evaluation objects that it receives.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("confusion-matrix", "confusionMatrix", (Object)false);
        this.m_OptionManager.add("comment", "comment", (Object)new BaseText(""));
    }

    public String getQuickInfo() {
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"confusionMatrix", (boolean)this.m_ConfusionMatrix, (String)"confusion matrix"));
        String result = QuickInfoHelper.flatten(options);
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"comment", this.m_Comment.stringValue().length() > 0 ? Shortening.shortenEnd((String)this.m_Comment.stringValue(), (int)20) : null);
        if (value != null) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + "comment: " + value;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, DL4JEvaluationContainer.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    public void setConfusionMatrix(boolean value) {
        this.m_ConfusionMatrix = value;
        this.reset();
    }

    public boolean getConfusionMatrix() {
        return this.m_ConfusionMatrix;
    }

    public String confusionMatrixTipText() {
        return "If set to true, then the confusion matrix will be output as well.";
    }

    public void setComment(BaseText value) {
        this.m_Comment = value;
        this.reset();
    }

    public BaseText getComment() {
        return this.m_Comment;
    }

    public String commentTipText() {
        return "An optional comment to output in the summary.";
    }

    protected String doExecute() {
        String result = null;
        Evaluation eval = this.m_InputToken.getPayload() instanceof DL4JEvaluationContainer ? (Evaluation)((DL4JEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Evaluation") : (Evaluation)this.m_InputToken.getPayload();
        StringBuilder buffer = new StringBuilder();
        boolean prolog = false;
        if (this.m_Comment.getValue().length() > 0) {
            String[] comment = this.m_Comment.getValue().split("\n");
            if (comment.length == 1) {
                buffer.append("Comment: " + this.m_Comment + "\n");
            } else {
                buffer.append("Comment:\n");
                for (String line : comment) {
                    buffer.append(line + "\n");
                }
            }
            prolog = true;
        }
        if (prolog) {
            buffer.append("\n");
        }
        buffer.append(eval.stats());
        if (this.m_ConfusionMatrix) {
            try {
                buffer.append("\n\n" + eval.confusionToString());
            }
            catch (Exception e) {
                result = this.handleException("Failed to generate confusion matrix: ", e);
            }
        }
        this.m_OutputToken = new Token((Object)buffer.toString());
        return result;
    }
}

