/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j;

import adams.core.ClassLocator;
import adams.core.SerializationHelper;
import java.io.File;
import java.lang.reflect.Constructor;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.layers.BaseOutputLayer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ModelSerialization {
    public static void write(File file, Model model) throws Exception {
        if (model instanceof MultiLayerNetwork) {
            SerializationHelper.writeAll((String)file.getAbsolutePath(), (Object[])new Object[]{model.getClass().getName(), ((MultiLayerNetwork)model).getLayerWiseConfigurations().toJson(), model.params()});
        } else {
            SerializationHelper.writeAll((String)file.getAbsolutePath(), (Object[])new Object[]{model.getClass().getName(), model.conf().toJson(), model.params()});
        }
    }

    public static Model read(File file) throws Exception {
        Object[] data = SerializationHelper.readAll((String)file.getAbsolutePath());
        if (data.length == 3) {
            Class<?> cls = Class.forName((String)data[0]);
            if (cls == MultiLayerNetwork.class) {
                MultiLayerNetwork result = new MultiLayerNetwork(MultiLayerConfiguration.fromJson((String)((String)data[1])));
                result.init();
                result.setParams((INDArray)data[2]);
                return result;
            }
            if (ClassLocator.isSubclass(BaseOutputLayer.class, cls)) {
                Constructor<?> constr = cls.getConstructor(NeuralNetConfiguration.class);
                if (constr != null) {
                    Model result = (Model)constr.newInstance(NeuralNetConfiguration.fromJson((String)((String)data[1])));
                    result.setParams((INDArray)data[2]);
                    return result;
                }
                throw new IllegalStateException("Failed to find constructor in class " + cls.getName() + " that takes a " + NeuralNetConfiguration.class.getName() + " object!");
            }
            throw new IllegalStateException("Don't know how to re-instantiate: " + cls.getName());
        }
        throw new IllegalStateException("Unexpected number of objects in serialized file (instead of 3): " + data.length);
    }
}

